/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1beta1.stub;

import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcRawCallableFactory;
import com.google.api.gax.retrying.ExponentialRetryAlgorithm;
import com.google.api.gax.retrying.RetryAlgorithm;
import com.google.api.gax.retrying.ScheduledRetryingExecutor;
import com.google.api.gax.retrying.StreamResumptionStrategy;
import com.google.api.gax.retrying.StreamingRetryAlgorithm;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.Callables;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.ServerStreamingCallSettings;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.gax.tracing.SpanName;
import com.google.api.gax.tracing.TracedServerStreamingCallable;
import com.google.cloud.bigquery.storage.v1beta1.BigQueryStorageGrpc;
import com.google.cloud.bigquery.storage.v1beta1.BigQueryStorageSettings;
import com.google.cloud.bigquery.storage.v1beta1.Storage;
import com.google.cloud.bigquery.storage.v1beta1.stub.BigQueryStorageStubSettings;
import com.google.cloud.bigquery.storage.v1beta1.stub.EnhancedBigQueryStorageStubSettings;
import com.google.cloud.bigquery.storage.v1beta1.stub.GrpcBigQueryStorageStub;
import com.google.cloud.bigquery.storage.v1beta1.stub.readrows.ApiResultRetryAlgorithm;
import com.google.cloud.bigquery.storage.v1beta1.stub.readrows.ReadRowsRetryingCallable;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class EnhancedBigQueryStorageStub
implements BackgroundResource {
    private static final String TRACING_OUTER_CLIENT_NAME = "BigQueryStorage";
    private final GrpcBigQueryStorageStub stub;
    private final BigQueryStorageStubSettings stubSettings;
    private final BigQueryStorageSettings.RetryAttemptListener readRowsRetryAttemptListener;
    private final ClientContext context;

    public static EnhancedBigQueryStorageStub create(EnhancedBigQueryStorageStubSettings settings) throws IOException {
        return EnhancedBigQueryStorageStub.create(settings, null);
    }

    public static EnhancedBigQueryStorageStub create(EnhancedBigQueryStorageStubSettings settings, BigQueryStorageSettings.RetryAttemptListener readRowsRetryAttemptListener) throws IOException {
        BigQueryStorageStubSettings.Builder baseSettingsBuilder = (BigQueryStorageStubSettings.Builder)((BigQueryStorageStubSettings.Builder)((BigQueryStorageStubSettings.Builder)((BigQueryStorageStubSettings.Builder)((BigQueryStorageStubSettings.Builder)((BigQueryStorageStubSettings.Builder)BigQueryStorageStubSettings.newBuilder().setUniverseDomain(settings.getUniverseDomain())).setTransportChannelProvider(settings.getTransportChannelProvider())).setHeaderProvider(settings.getHeaderProvider())).setCredentialsProvider(settings.getCredentialsProvider())).setStreamWatchdogCheckInterval(settings.getStreamWatchdogCheckInterval())).setStreamWatchdogProvider(settings.getStreamWatchdogProvider());
        baseSettingsBuilder.createReadSessionSettings().setRetryableCodes(settings.createReadSessionSettings().getRetryableCodes()).setRetrySettings(settings.createReadSessionSettings().getRetrySettings());
        baseSettingsBuilder.readRowsSettings().setRetryableCodes(settings.readRowsSettings().getRetryableCodes()).setRetrySettings(settings.readRowsSettings().getRetrySettings()).setResumptionStrategy(settings.readRowsSettings().getResumptionStrategy()).setIdleTimeout(settings.readRowsSettings().getIdleTimeout());
        baseSettingsBuilder.batchCreateReadSessionStreamsSettings().setRetryableCodes(settings.batchCreateReadSessionStreamsSettings().getRetryableCodes()).setRetrySettings(settings.batchCreateReadSessionStreamsSettings().getRetrySettings());
        baseSettingsBuilder.finalizeStreamSettings().setRetryableCodes(settings.finalizeStreamSettings().getRetryableCodes()).setRetrySettings(settings.finalizeStreamSettings().getRetrySettings());
        baseSettingsBuilder.splitReadStreamSettings().setRetryableCodes(settings.splitReadStreamSettings().getRetryableCodes()).setRetrySettings(settings.splitReadStreamSettings().getRetrySettings());
        BigQueryStorageStubSettings baseSettings = baseSettingsBuilder.build();
        ClientContext clientContext = ClientContext.create((StubSettings)baseSettings);
        GrpcBigQueryStorageStub stub = new GrpcBigQueryStorageStub(baseSettings, clientContext);
        return new EnhancedBigQueryStorageStub(stub, baseSettings, readRowsRetryAttemptListener, clientContext);
    }

    @InternalApi(value="Visible for testing")
    EnhancedBigQueryStorageStub(GrpcBigQueryStorageStub stub, BigQueryStorageStubSettings stubSettings, BigQueryStorageSettings.RetryAttemptListener readRowsRetryAttemptListener, ClientContext context) {
        this.stub = stub;
        this.stubSettings = stubSettings;
        this.readRowsRetryAttemptListener = readRowsRetryAttemptListener;
        this.context = context;
    }

    public UnaryCallable<Storage.CreateReadSessionRequest, Storage.ReadSession> createReadSessionCallable() {
        return this.stub.createReadSessionCallable();
    }

    public ServerStreamingCallable<Storage.ReadRowsRequest, Storage.ReadRowsResponse> readRowsCallable() {
        ServerStreamingCallable innerCallable = GrpcRawCallableFactory.createServerStreamingCallable((GrpcCallSettings)GrpcCallSettings.newBuilder().setMethodDescriptor(BigQueryStorageGrpc.getReadRowsMethod()).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<Storage.ReadRowsRequest>(){

            public Map<String, String> extract(Storage.ReadRowsRequest request) {
                return ImmutableMap.of((Object)"read_position.stream.name", (Object)String.valueOf(request.getReadPosition().getStream().getName()));
            }
        }).build(), (Set)this.stubSettings.readRowsSettings().getRetryableCodes());
        ServerStreamingCallSettings<Storage.ReadRowsRequest, Storage.ReadRowsResponse> callSettings = this.stubSettings.readRowsSettings();
        StreamingRetryAlgorithm retryAlgorithm = new StreamingRetryAlgorithm(new ApiResultRetryAlgorithm(this.readRowsRetryAttemptListener), (TimedRetryAlgorithm)new ExponentialRetryAlgorithm(callSettings.getRetrySettings(), this.context.getClock()));
        ScheduledRetryingExecutor retryingExecutor = new ScheduledRetryingExecutor((RetryAlgorithm)retryAlgorithm, this.context.getExecutor());
        if (this.context.getStreamWatchdog() != null) {
            innerCallable = Callables.watched((ServerStreamingCallable)innerCallable, callSettings, (ClientContext)this.context);
        }
        ReadRowsRetryingCallable outerCallable = new ReadRowsRetryingCallable(this.context.getDefaultCallContext(), (ServerStreamingCallable<Storage.ReadRowsRequest, Storage.ReadRowsResponse>)innerCallable, (ScheduledRetryingExecutor<Void>)retryingExecutor, (StreamResumptionStrategy<Storage.ReadRowsRequest, Storage.ReadRowsResponse>)callSettings.getResumptionStrategy());
        TracedServerStreamingCallable traced = new TracedServerStreamingCallable((ServerStreamingCallable)outerCallable, this.context.getTracerFactory(), SpanName.of((String)TRACING_OUTER_CLIENT_NAME, (String)"ReadRows"));
        return traced.withDefaultCallContext(this.context.getDefaultCallContext());
    }

    public UnaryCallable<Storage.BatchCreateReadSessionStreamsRequest, Storage.BatchCreateReadSessionStreamsResponse> batchCreateReadSessionStreamsCallable() {
        return this.stub.batchCreateReadSessionStreamsCallable();
    }

    public UnaryCallable<Storage.FinalizeStreamRequest, Empty> finalizeStreamCallable() {
        return this.stub.finalizeStreamCallable();
    }

    public UnaryCallable<Storage.SplitReadStreamRequest, Storage.SplitReadStreamResponse> splitReadStreamCallable() {
        return this.stub.splitReadStreamCallable();
    }

    public void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

