/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.ref;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.ref.AbstractReference;
import net.openhft.chronicle.core.values.IntValue;
import org.jetbrains.annotations.NotNull;

public class BinaryIntReference
extends AbstractReference
implements IntValue {
    public static final int INT_NOT_COMPLETE = Integer.MIN_VALUE;

    @Override
    public void bytesStore(@NotNull BytesStore bytes, long offset, long length) throws IllegalStateException, IllegalArgumentException, BufferOverflowException, BufferUnderflowException {
        this.throwExceptionIfClosedInSetter();
        if (length != this.maxSize()) {
            throw new IllegalArgumentException();
        }
        super.bytesStore(bytes, offset, length);
    }

    @Override
    public long maxSize() {
        return 4L;
    }

    @NotNull
    public String toString() {
        return this.bytes == null ? "bytes is null" : "value: " + this.getValue();
    }

    public int getValue() {
        this.throwExceptionIfClosed();
        return this.bytes == null ? 0 : this.bytes.readInt(this.offset);
    }

    public void setValue(int value) {
        this.throwExceptionIfClosedInSetter();
        this.bytes.writeInt(this.offset, value);
    }

    public int getVolatileValue() {
        this.throwExceptionIfClosed();
        return this.bytes.readVolatileInt(this.offset);
    }

    public void setOrderedValue(int value) {
        this.throwExceptionIfClosedInSetter();
        this.bytes.writeOrderedInt(this.offset, value);
    }

    public int addValue(int delta) {
        this.throwExceptionIfClosed();
        return this.bytes.addAndGetInt(this.offset, delta);
    }

    public int addAtomicValue(int delta) {
        this.throwExceptionIfClosed();
        return this.addValue(delta);
    }

    public boolean compareAndSwapValue(int expected, int value) {
        this.throwExceptionIfClosed();
        return this.bytes.compareAndSwapInt(this.offset, expected, value);
    }
}

