/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Queue;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferBuilder;
import org.apache.flink.runtime.io.network.buffer.BufferConsumer;
import org.apache.flink.runtime.io.network.buffer.FreeingBufferRecycler;
import org.apache.flink.runtime.io.network.buffer.NetworkBuffer;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageSubpartitionId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.HashSubpartitionBufferAccumulatorContext;
import org.apache.flink.util.Preconditions;

public class HashSubpartitionBufferAccumulator {
    private final TieredStorageSubpartitionId subpartitionId;
    private final int bufferSize;
    private final HashSubpartitionBufferAccumulatorContext bufferAccumulatorContext;
    private final Queue<BufferBuilder> unfinishedBuffers = new LinkedList<BufferBuilder>();
    private final boolean isPartialRecordAllowed;

    public HashSubpartitionBufferAccumulator(TieredStorageSubpartitionId subpartitionId, int bufferSize, HashSubpartitionBufferAccumulatorContext bufferAccumulatorContext, boolean isPartialRecordAllowed) {
        this.subpartitionId = subpartitionId;
        this.bufferSize = bufferSize;
        this.bufferAccumulatorContext = bufferAccumulatorContext;
        this.isPartialRecordAllowed = isPartialRecordAllowed;
    }

    public void append(ByteBuffer record, Buffer.DataType dataType) throws IOException {
        if (dataType.isEvent()) {
            this.writeEvent(record, dataType);
        } else {
            this.writeRecord(record, dataType);
        }
    }

    public void close() {
        this.finishCurrentWritingBufferIfNotEmpty();
        while (!this.unfinishedBuffers.isEmpty()) {
            this.unfinishedBuffers.poll().close();
        }
    }

    private void writeEvent(ByteBuffer event, Buffer.DataType dataType) {
        Preconditions.checkArgument((boolean)dataType.isEvent());
        this.finishCurrentWritingBufferIfNotEmpty();
        MemorySegment data = MemorySegmentFactory.wrap((byte[])event.array());
        this.flushFinishedBuffer(new NetworkBuffer(data, FreeingBufferRecycler.INSTANCE, dataType, data.size()), 0);
    }

    private void writeRecord(ByteBuffer record, Buffer.DataType dataType) {
        Preconditions.checkArgument((!dataType.isEvent() ? 1 : 0) != 0);
        this.ensureCapacityForRecord(record);
        this.writeRecord(record);
    }

    private void ensureCapacityForRecord(ByteBuffer record) {
        int numRecordBytes = record.remaining();
        if (!this.isPartialRecordAllowed && !this.unfinishedBuffers.isEmpty() && this.unfinishedBuffers.peek().getWritableBytes() < numRecordBytes) {
            this.finishCurrentWritingBufferIfNotEmpty();
        }
        for (int availableBytes = Optional.ofNullable(this.unfinishedBuffers.peek()).map(currentWritingBuffer -> currentWritingBuffer.getWritableBytes() + this.bufferSize * (this.unfinishedBuffers.size() - 1)).orElse(0).intValue(); availableBytes < numRecordBytes; availableBytes += this.bufferSize) {
            BufferBuilder bufferBuilder = this.bufferAccumulatorContext.requestBufferBlocking();
            this.unfinishedBuffers.add(bufferBuilder);
        }
    }

    private void writeRecord(ByteBuffer record) {
        boolean needFinalFlush = false;
        while (record.hasRemaining()) {
            BufferBuilder currentWritingBuffer = (BufferBuilder)Preconditions.checkNotNull((Object)this.unfinishedBuffers.peek());
            currentWritingBuffer.append(record);
            if (!currentWritingBuffer.isFull()) continue;
            int numRemainingConsecutiveBuffers = 0;
            if (!this.isPartialRecordAllowed) {
                needFinalFlush = true;
                numRemainingConsecutiveBuffers = (int)Math.ceil((double)record.remaining() / (double)this.bufferSize);
            }
            this.finishCurrentWritingBuffer(numRemainingConsecutiveBuffers);
        }
        if (needFinalFlush) {
            this.finishCurrentWritingBuffer(0);
        }
    }

    private void finishCurrentWritingBufferIfNotEmpty() {
        BufferBuilder currentWritingBuffer = this.unfinishedBuffers.peek();
        if (currentWritingBuffer == null || currentWritingBuffer.getWritableBytes() == this.bufferSize) {
            return;
        }
        this.finishCurrentWritingBuffer(0);
    }

    private void finishCurrentWritingBuffer(int numRemainingConsecutiveBuffers) {
        BufferBuilder currentWritingBuffer = this.unfinishedBuffers.poll();
        if (currentWritingBuffer == null) {
            return;
        }
        if (currentWritingBuffer.getDataType() == Buffer.DataType.DATA_BUFFER && !this.isPartialRecordAllowed && numRemainingConsecutiveBuffers == 0) {
            currentWritingBuffer.setDataType(Buffer.DataType.DATA_BUFFER_WITH_CLEAR_END);
        }
        currentWritingBuffer.finish();
        BufferConsumer bufferConsumer = currentWritingBuffer.createBufferConsumerFromBeginning();
        Buffer buffer = bufferConsumer.build();
        currentWritingBuffer.close();
        bufferConsumer.close();
        this.flushFinishedBuffer(buffer, numRemainingConsecutiveBuffers);
    }

    private void flushFinishedBuffer(Buffer finishedBuffer, int numRemainingConsecutiveBuffers) {
        this.bufferAccumulatorContext.flushAccumulatedBuffers(this.subpartitionId, finishedBuffer, numRemainingConsecutiveBuffers);
    }
}

