/*
 * Decompiled with CFR 0.152.
 */
package dev.ai4j.openai4j.chat;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Parameters {
    private final String type = "object";
    private final Map<String, Map<String, Object>> properties;
    private final List<String> required;

    private Parameters(Builder builder) {
        this.properties = builder.properties;
        this.required = builder.required;
    }

    public String type() {
        return "object";
    }

    public Map<String, Map<String, Object>> properties() {
        return this.properties;
    }

    public List<String> required() {
        return this.required;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Parameters && this.equalTo((Parameters)another);
    }

    private boolean equalTo(Parameters another) {
        return Objects.equals(this.properties, another.properties) && Objects.equals(this.required, another.required);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode("object");
        h += (h << 5) + Objects.hashCode(this.properties);
        h += (h << 5) + Objects.hashCode(this.required);
        return h;
    }

    public String toString() {
        return "Parameters{type=object, properties=" + this.properties + ", required=" + this.required + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Map<String, Map<String, Object>> properties = new HashMap<String, Map<String, Object>>();
        private List<String> required = new ArrayList<String>();

        private Builder() {
        }

        public Builder properties(Map<String, Map<String, Object>> properties) {
            if (properties != null) {
                this.properties = Collections.unmodifiableMap(properties);
            }
            return this;
        }

        public Builder required(List<String> required) {
            if (required != null) {
                this.required = Collections.unmodifiableList(required);
            }
            return this;
        }

        public Parameters build() {
            return new Parameters(this);
        }
    }
}

