/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core;

import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolderRenderer;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class SafeCTabFolderRenderer
extends CTabFolderRenderer {
    private final CTabFolder parentFolder;

    public SafeCTabFolderRenderer(CTabFolder parent) {
        super(parent);
        this.parentFolder = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void draw(int part, int state, Rectangle bounds, GC gc) {
        block13: {
            if (bounds != null && (bounds.width <= 0 || bounds.height <= 0)) {
                return;
            }
            Image[] savedImages = null;
            boolean hadInvalidImages = false;
            if (this.parentFolder != null && !this.parentFolder.isDisposed()) {
                CTabItem[] items = this.parentFolder.getItems();
                savedImages = new Image[items.length];
                for (int i = 0; i < items.length; ++i) {
                    Image image;
                    savedImages[i] = image = items[i].getImage();
                    if (image == null || !image.isDisposed()) continue;
                    items[i].setImage(null);
                    hadInvalidImages = true;
                }
            }
            try {
                super.draw(part, state, bounds, gc);
            }
            catch (IllegalArgumentException e) {
                if (this.parentFolder == null || this.parentFolder.isDisposed()) break block13;
                CTabItem[] items = this.parentFolder.getItems();
                for (int i = 0; i < items.length && savedImages != null && i < savedImages.length; ++i) {
                    if (savedImages[i] == null || items[i].getImage() == null) continue;
                    items[i].setImage(null);
                }
                try {
                    super.draw(part, state, bounds, gc);
                }
                finally {
                    this.restoreImages(items, savedImages);
                }
            }
            finally {
                if (hadInvalidImages && this.parentFolder != null && !this.parentFolder.isDisposed()) {
                    this.restoreImages(this.parentFolder.getItems(), savedImages);
                }
            }
        }
    }

    private void restoreImages(CTabItem[] items, Image[] savedImages) {
        if (items == null || savedImages == null) {
            return;
        }
        for (int i = 0; i < items.length && i < savedImages.length; ++i) {
            if (savedImages[i] == null || savedImages[i].isDisposed()) continue;
            items[i].setImage(savedImages[i]);
        }
    }
}

