/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.common;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.common.RootInfo;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import javax.annotation.Nonnull;

public class UserRootInfo
extends RootInfo {
    public UserRootInfo(@Nonnull String rootNamespaceId, @Nonnull String homeNamespaceId) {
        super(rootNamespaceId, homeNamespaceId);
    }

    @Override
    @Nonnull
    public String getRootNamespaceId() {
        return this.rootNamespaceId;
    }

    @Override
    @Nonnull
    public String getHomeNamespaceId() {
        return this.homeNamespaceId;
    }

    @Override
    public int hashCode() {
        return this.getClass().toString().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            UserRootInfo other = (UserRootInfo)obj;
            return !(this.rootNamespaceId != other.rootNamespaceId && !this.rootNamespaceId.equals(other.rootNamespaceId) || this.homeNamespaceId != other.homeNamespaceId && !this.homeNamespaceId.equals(other.homeNamespaceId));
        }
        return false;
    }

    @Override
    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    @Override
    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<UserRootInfo> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(UserRootInfo value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            this.writeTag("user", g);
            g.writeFieldName("root_namespace_id");
            StoneSerializers.string().serialize(value.rootNamespaceId, g);
            g.writeFieldName("home_namespace_id");
            StoneSerializers.string().serialize(value.homeNamespaceId, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public UserRootInfo deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            String f_homeNamespaceId;
            String f_rootNamespaceId;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
                if ("user".equals(tag)) {
                    tag = null;
                }
            }
            if (tag == null) {
                f_rootNamespaceId = null;
                f_homeNamespaceId = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("root_namespace_id".equals(field)) {
                        f_rootNamespaceId = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("home_namespace_id".equals(field)) {
                        f_homeNamespaceId = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_rootNamespaceId == null) {
                    throw new JsonParseException(p, "Required field \"root_namespace_id\" missing.");
                }
                if (f_homeNamespaceId == null) {
                    throw new JsonParseException(p, "Required field \"home_namespace_id\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            UserRootInfo value = new UserRootInfo(f_rootNamespaceId, f_homeNamespaceId);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

