/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.io.Serializable;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.AutoValue_TFRecordReadSchemaTransformConfiguration;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.fs.MatchResult;
import org.apache.beam.sdk.schemas.AutoValueSchema;
import org.apache.beam.sdk.schemas.annotations.DefaultSchema;
import org.apache.beam.sdk.schemas.annotations.SchemaFieldDescription;
import org.apache.beam.sdk.schemas.transforms.providers.ErrorHandling;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Strings;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@DefaultSchema(value=AutoValueSchema.class)
@AutoValue
public abstract class TFRecordReadSchemaTransformConfiguration
implements Serializable {
    public void validate() {
        ErrorHandling errorHandling;
        String invalidConfigMessage = "Invalid TFRecord Read configuration: ";
        if (this.getValidate()) {
            String filePattern = this.getFilePattern();
            try {
                MatchResult matches = FileSystems.match(filePattern);
                Preconditions.checkState((!matches.metadata().isEmpty() ? 1 : 0) != 0, (String)"Unable to find any files matching %s", (Object)filePattern);
            }
            catch (IOException e) {
                throw new IllegalStateException(String.format(invalidConfigMessage + "Failed to validate %s", filePattern), e);
            }
        }
        if ((errorHandling = this.getErrorHandling()) != null) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)errorHandling.getOutput()) ? 1 : 0) != 0, (String)"%sOutput must not be empty if error handling specified.", (Object)invalidConfigMessage);
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized Builder builder() {
        return new AutoValue_TFRecordReadSchemaTransformConfiguration.Builder();
    }

    @SchemaFieldDescription(value="Validate file pattern.")
    public abstract @UnknownKeyFor @NonNull @Initialized boolean getValidate();

    @SchemaFieldDescription(value="Decompression type to use when reading input files.")
    public abstract @UnknownKeyFor @NonNull @Initialized String getCompression();

    @SchemaFieldDescription(value="Filename or file pattern used to find input files.")
    public abstract @UnknownKeyFor @NonNull @Initialized String getFilePattern();

    @SchemaFieldDescription(value="This option specifies whether and where to output unwritable rows.")
    @Nullable
    public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized ErrorHandling getErrorHandling();

    abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract @UnknownKeyFor @NonNull @Initialized Builder setValidate(@UnknownKeyFor @NonNull @Initialized boolean var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setCompression(@UnknownKeyFor @NonNull @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setFilePattern(@UnknownKeyFor @NonNull @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setErrorHandling(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized ErrorHandling var1);

        public abstract @UnknownKeyFor @NonNull @Initialized TFRecordReadSchemaTransformConfiguration build();
    }
}

