/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.common;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.aws2.common.RetryConfiguration;
import org.checkerframework.dataflow.qual.Pure;
import org.joda.time.Duration;

final class AutoValue_RetryConfiguration
extends RetryConfiguration {
    private final int numRetries;
    private final Duration baseBackoff;
    private final Duration throttledBaseBackoff;
    private final Duration maxBackoff;

    private AutoValue_RetryConfiguration(int numRetries, @Nullable Duration baseBackoff, @Nullable Duration throttledBaseBackoff, @Nullable Duration maxBackoff) {
        this.numRetries = numRetries;
        this.baseBackoff = baseBackoff;
        this.throttledBaseBackoff = throttledBaseBackoff;
        this.maxBackoff = maxBackoff;
    }

    @Override
    @JsonProperty
    @Pure
    public int numRetries() {
        return this.numRetries;
    }

    @Override
    @JsonProperty
    @JsonSerialize(converter=RetryConfiguration.DurationToMillis.class)
    @Nullable
    @Pure
    public Duration baseBackoff() {
        return this.baseBackoff;
    }

    @Override
    @JsonProperty
    @JsonSerialize(converter=RetryConfiguration.DurationToMillis.class)
    @Nullable
    @Pure
    public Duration throttledBaseBackoff() {
        return this.throttledBaseBackoff;
    }

    @Override
    @JsonProperty
    @JsonSerialize(converter=RetryConfiguration.DurationToMillis.class)
    @Nullable
    @Pure
    public Duration maxBackoff() {
        return this.maxBackoff;
    }

    public String toString() {
        return "RetryConfiguration{numRetries=" + this.numRetries + ", baseBackoff=" + this.baseBackoff + ", throttledBaseBackoff=" + this.throttledBaseBackoff + ", maxBackoff=" + this.maxBackoff + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof RetryConfiguration) {
            RetryConfiguration that = (RetryConfiguration)o;
            return this.numRetries == that.numRetries() && (this.baseBackoff == null ? that.baseBackoff() == null : this.baseBackoff.equals((Object)that.baseBackoff())) && (this.throttledBaseBackoff == null ? that.throttledBaseBackoff() == null : this.throttledBaseBackoff.equals((Object)that.throttledBaseBackoff())) && (this.maxBackoff == null ? that.maxBackoff() == null : this.maxBackoff.equals((Object)that.maxBackoff()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.numRetries;
        h$ *= 1000003;
        h$ ^= this.baseBackoff == null ? 0 : this.baseBackoff.hashCode();
        h$ *= 1000003;
        h$ ^= this.throttledBaseBackoff == null ? 0 : this.throttledBaseBackoff.hashCode();
        h$ *= 1000003;
        return h$ ^= this.maxBackoff == null ? 0 : this.maxBackoff.hashCode();
    }

    @Override
    public RetryConfiguration.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends RetryConfiguration.Builder {
        private Integer numRetries;
        private Duration baseBackoff;
        private Duration throttledBaseBackoff;
        private Duration maxBackoff;

        Builder() {
        }

        private Builder(RetryConfiguration source) {
            this.numRetries = source.numRetries();
            this.baseBackoff = source.baseBackoff();
            this.throttledBaseBackoff = source.throttledBaseBackoff();
            this.maxBackoff = source.maxBackoff();
        }

        @Override
        public RetryConfiguration.Builder numRetries(int numRetries) {
            this.numRetries = numRetries;
            return this;
        }

        @Override
        public RetryConfiguration.Builder baseBackoff(Duration baseBackoff) {
            this.baseBackoff = baseBackoff;
            return this;
        }

        @Override
        public RetryConfiguration.Builder throttledBaseBackoff(Duration throttledBaseBackoff) {
            this.throttledBaseBackoff = throttledBaseBackoff;
            return this;
        }

        @Override
        public RetryConfiguration.Builder maxBackoff(Duration maxBackoff) {
            this.maxBackoff = maxBackoff;
            return this;
        }

        @Override
        RetryConfiguration autoBuild() {
            if (this.numRetries == null) {
                String missing = " numRetries";
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_RetryConfiguration(this.numRetries, this.baseBackoff, this.throttledBaseBackoff, this.maxBackoff);
        }
    }
}

