/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.s3;

import java.io.IOException;
import java.util.List;
import org.apache.beam.sdk.io.aws2.s3.S3FileSystem;
import org.apache.beam.sdk.io.aws2.s3.S3ResourceId;
import org.checkerframework.checker.nullness.qual.Nullable;

final class AutoValue_S3FileSystem_ExpandedGlob
extends S3FileSystem.ExpandedGlob {
    private final S3ResourceId globPath;
    private final @Nullable List<S3ResourceId> expandedPaths;
    private final @Nullable IOException exception;

    AutoValue_S3FileSystem_ExpandedGlob(S3ResourceId globPath, @Nullable List<S3ResourceId> expandedPaths, @Nullable IOException exception) {
        if (globPath == null) {
            throw new NullPointerException("Null globPath");
        }
        this.globPath = globPath;
        this.expandedPaths = expandedPaths;
        this.exception = exception;
    }

    @Override
    S3ResourceId getGlobPath() {
        return this.globPath;
    }

    @Override
    @Nullable List<S3ResourceId> getExpandedPaths() {
        return this.expandedPaths;
    }

    @Override
    @Nullable IOException getException() {
        return this.exception;
    }

    public String toString() {
        return "ExpandedGlob{globPath=" + this.globPath + ", expandedPaths=" + this.expandedPaths + ", exception=" + this.exception + "}";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof S3FileSystem.ExpandedGlob) {
            S3FileSystem.ExpandedGlob that = (S3FileSystem.ExpandedGlob)o;
            return this.globPath.equals(that.getGlobPath()) && (this.expandedPaths == null ? that.getExpandedPaths() == null : this.expandedPaths.equals(that.getExpandedPaths())) && (this.exception == null ? that.getException() == null : this.exception.equals(that.getException()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.globPath.hashCode();
        h$ *= 1000003;
        h$ ^= this.expandedPaths == null ? 0 : this.expandedPaths.hashCode();
        h$ *= 1000003;
        return h$ ^= this.exception == null ? 0 : this.exception.hashCode();
    }
}

