/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.file;

import com.microsoft.azure.storage.core.Utility;
import com.microsoft.azure.storage.file.ShareStats;
import java.io.IOException;
import java.io.InputStream;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

final class ShareStatsHandler
extends DefaultHandler {
    private static final String USAGE_NAME = "ShareUsage";
    private final Stack<String> elementStack = new Stack();
    private StringBuilder builder = new StringBuilder();
    private final ShareStats stats = new ShareStats();

    ShareStatsHandler() {
    }

    public static ShareStats readShareStatsFromStream(InputStream inStream) throws ParserConfigurationException, SAXException, IOException {
        SAXParser saxParser = Utility.getSAXParser();
        ShareStatsHandler handler = new ShareStatsHandler();
        saxParser.parse(inStream, (DefaultHandler)handler);
        return handler.stats;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.elementStack.push(localName);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String currentNode = this.elementStack.pop();
        if (!localName.equals(currentNode)) {
            throw new SAXException("The response received is invalid or improperly formatted.");
        }
        if (USAGE_NAME.equals(currentNode)) {
            this.stats.setUsage(Integer.parseInt(this.builder.toString()));
        }
        this.builder = new StringBuilder();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.builder.append(ch, start, length);
    }
}

