/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.tablecompare;

import java.sql.ResultSet;
import org.apache.hop.core.Const;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.tablecompare.TableCompareData;
import org.apache.hop.pipeline.transforms.tablecompare.TableCompareMeta;

public class TableCompare
extends BaseTransform<TableCompareMeta, TableCompareData> {
    private static final Class<?> PKG = TableCompare.class;
    public static final String CONST_TABLE_COMPARE_EXCEPTION_CAN_NOT_FIND_FIELD = "TableCompare.Exception.CanNotFindField";

    public TableCompare(TransformMeta transformMeta, TableCompareMeta meta, TableCompareData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            ((TableCompareData)this.data).outputRowMeta = this.getInputRowMeta().clone();
            ((TableCompareMeta)this.meta).getFields(((TableCompareData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            if (Utils.isEmpty((CharSequence)((TableCompareMeta)this.meta).getReferenceSchemaField())) {
                throw new HopException(BaseMessages.getString(PKG, (String)"TableCompare.Exception.ReferenceSchemaNotSpecified", (String[])new String[0]));
            }
            ((TableCompareData)this.data).refSchemaIndex = this.getInputRowMeta().indexOfValue(((TableCompareMeta)this.meta).getReferenceSchemaField());
            if (((TableCompareData)this.data).refSchemaIndex < 0) {
                throw new HopException(BaseMessages.getString(PKG, (String)CONST_TABLE_COMPARE_EXCEPTION_CAN_NOT_FIND_FIELD, (String[])new String[]{((TableCompareMeta)this.meta).getReferenceSchemaField()}));
            }
            if (Utils.isEmpty((CharSequence)((TableCompareMeta)this.meta).getReferenceTableField())) {
                throw new HopException(BaseMessages.getString(PKG, (String)"TableCompare.Exception.ReferenceTableNotSpecified", (String[])new String[0]));
            }
            ((TableCompareData)this.data).refTableIndex = this.getInputRowMeta().indexOfValue(((TableCompareMeta)this.meta).getReferenceTableField());
            if (((TableCompareData)this.data).refTableIndex < 0) {
                throw new HopException(BaseMessages.getString(PKG, (String)CONST_TABLE_COMPARE_EXCEPTION_CAN_NOT_FIND_FIELD, (String[])new String[]{((TableCompareMeta)this.meta).getReferenceTableField()}));
            }
            if (Utils.isEmpty((CharSequence)((TableCompareMeta)this.meta).getCompareSchemaField())) {
                throw new HopException(BaseMessages.getString(PKG, (String)"TableCompare.Exception.CompareSchemaNotSpecified", (String[])new String[0]));
            }
            ((TableCompareData)this.data).cmpSchemaIndex = this.getInputRowMeta().indexOfValue(((TableCompareMeta)this.meta).getCompareSchemaField());
            if (((TableCompareData)this.data).cmpSchemaIndex < 0) {
                throw new HopException(BaseMessages.getString(PKG, (String)CONST_TABLE_COMPARE_EXCEPTION_CAN_NOT_FIND_FIELD, (String[])new String[]{((TableCompareMeta)this.meta).getCompareSchemaField()}));
            }
            if (Utils.isEmpty((CharSequence)((TableCompareMeta)this.meta).getCompareTableField())) {
                throw new HopException(BaseMessages.getString(PKG, (String)"TableCompare.Exception.CompareTableNotSpecified", (String[])new String[0]));
            }
            ((TableCompareData)this.data).cmpTableIndex = this.getInputRowMeta().indexOfValue(((TableCompareMeta)this.meta).getCompareTableField());
            if (((TableCompareData)this.data).cmpTableIndex < 0) {
                throw new HopException(BaseMessages.getString(PKG, (String)CONST_TABLE_COMPARE_EXCEPTION_CAN_NOT_FIND_FIELD, (String[])new String[]{((TableCompareMeta)this.meta).getCompareTableField()}));
            }
            if (Utils.isEmpty((CharSequence)((TableCompareMeta)this.meta).getKeyFieldsField())) {
                throw new HopException(BaseMessages.getString(PKG, (String)"TableCompare.Exception.KeyFieldsNotSpecified", (String[])new String[0]));
            }
            ((TableCompareData)this.data).keyFieldsIndex = this.getInputRowMeta().indexOfValue(((TableCompareMeta)this.meta).getKeyFieldsField());
            if (((TableCompareData)this.data).keyFieldsIndex < 0) {
                throw new HopException(BaseMessages.getString(PKG, (String)CONST_TABLE_COMPARE_EXCEPTION_CAN_NOT_FIND_FIELD, (String[])new String[]{((TableCompareMeta)this.meta).getKeyFieldsField()}));
            }
            if (Utils.isEmpty((CharSequence)((TableCompareMeta)this.meta).getExcludeFieldsField())) {
                throw new HopException(BaseMessages.getString(PKG, (String)"TableCompare.Exception.ExcludeFieldsNotSpecified", (String[])new String[0]));
            }
            ((TableCompareData)this.data).excludeFieldsIndex = this.getInputRowMeta().indexOfValue(((TableCompareMeta)this.meta).getExcludeFieldsField());
            if (((TableCompareData)this.data).excludeFieldsIndex < 0) {
                throw new HopException(BaseMessages.getString(PKG, (String)CONST_TABLE_COMPARE_EXCEPTION_CAN_NOT_FIND_FIELD, (String[])new String[]{((TableCompareMeta)this.meta).getExcludeFieldsField()}));
            }
            if (Utils.isEmpty((CharSequence)((TableCompareMeta)this.meta).getKeyDescriptionField())) {
                throw new HopException(BaseMessages.getString(PKG, (String)"TableCompare.Exception.KeyDescriptionFieldNotSpecified", (String[])new String[0]));
            }
            ((TableCompareData)this.data).keyDescIndex = this.getInputRowMeta().indexOfValue(((TableCompareMeta)this.meta).getKeyDescriptionField());
            if (((TableCompareData)this.data).keyDescIndex < 0) {
                throw new HopException(BaseMessages.getString(PKG, (String)CONST_TABLE_COMPARE_EXCEPTION_CAN_NOT_FIND_FIELD, (String[])new String[]{((TableCompareMeta)this.meta).getKeyDescriptionField()}));
            }
            if (Utils.isEmpty((CharSequence)((TableCompareMeta)this.meta).getValueReferenceField())) {
                throw new HopException(BaseMessages.getString(PKG, (String)"TableCompare.Exception.ValueReferenceFieldNotSpecified", (String[])new String[0]));
            }
            ((TableCompareData)this.data).valueReferenceIndex = this.getInputRowMeta().indexOfValue(((TableCompareMeta)this.meta).getValueReferenceField());
            if (((TableCompareData)this.data).valueReferenceIndex < 0) {
                throw new HopException(BaseMessages.getString(PKG, (String)CONST_TABLE_COMPARE_EXCEPTION_CAN_NOT_FIND_FIELD, (String[])new String[]{((TableCompareMeta)this.meta).getValueReferenceField()}));
            }
            if (Utils.isEmpty((CharSequence)((TableCompareMeta)this.meta).getValueCompareField())) {
                throw new HopException(BaseMessages.getString(PKG, (String)"TableCompare.Exception.ValueCompareFieldNotSpecified", (String[])new String[0]));
            }
            ((TableCompareData)this.data).valueCompareIndex = this.getInputRowMeta().indexOfValue(((TableCompareMeta)this.meta).getValueCompareField());
            if (((TableCompareData)this.data).valueCompareIndex < 0) {
                throw new HopException(BaseMessages.getString(PKG, (String)CONST_TABLE_COMPARE_EXCEPTION_CAN_NOT_FIND_FIELD, (String[])new String[]{((TableCompareMeta)this.meta).getValueCompareField()}));
            }
        }
        Object[] fields = this.compareTables(this.getInputRowMeta(), r);
        Object[] outputRowData = RowDataUtil.addRowData((Object[])r, (int)this.getInputRowMeta().size(), (Object[])fields);
        this.putRow(((TableCompareData)this.data).outputRowMeta, outputRowData);
        return true;
    }

    private Object[] compareTables(IRowMeta rowMeta, Object[] r) throws HopException {
        try {
            String referenceSchema = this.getInputRowMeta().getString(r, ((TableCompareData)this.data).refSchemaIndex);
            String referenceTable = this.getInputRowMeta().getString(r, ((TableCompareData)this.data).refTableIndex);
            String compareSchema = this.getInputRowMeta().getString(r, ((TableCompareData)this.data).cmpSchemaIndex);
            String compareTable = this.getInputRowMeta().getString(r, ((TableCompareData)this.data).cmpTableIndex);
            String keyFields = this.getInputRowMeta().getString(r, ((TableCompareData)this.data).keyFieldsIndex);
            String excludeFields = this.getInputRowMeta().getString(r, ((TableCompareData)this.data).excludeFieldsIndex);
            return this.compareTables(rowMeta, r, referenceSchema, referenceTable, compareSchema, compareTable, keyFields, excludeFields);
        }
        catch (Exception e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"TableCompare.Exception.UnexpectedErrorComparingTables", (String[])new String[0]), (Throwable)e);
        }
    }

    private Object[] compareTables(IRowMeta rowMeta, Object[] r, String referenceSchema, String referenceTable, String compareSchema, String compareTable, String keyFields, String excludeFields) throws HopException {
        Object[] errorRowData;
        long nrErrors = 0L;
        long nrLeftErrors = 0L;
        long nrRightErrors = 0L;
        long nrInnerErrors = 0L;
        long nrRecordsReference = 0L;
        long nrRecordsCompare = 0L;
        Object[] result = new Object[6];
        if (Utils.isEmpty((CharSequence)referenceTable)) {
            errorRowData = this.constructErrorRow(rowMeta, r, null, null, null);
            this.putError(((TableCompareData)this.data).errorRowMeta, errorRowData, 1L, BaseMessages.getString(PKG, (String)"TableCompare.Exception.NoReferenceTableDefined", (String[])new String[0]), null, "TAC008");
            ++nrErrors;
        }
        if (Utils.isEmpty((CharSequence)compareTable)) {
            errorRowData = this.constructErrorRow(rowMeta, r, null, null, null);
            this.putError(((TableCompareData)this.data).errorRowMeta, errorRowData, 1L, BaseMessages.getString(PKG, (String)"TableCompare.Exception.NoCompareTableDefined", (String[])new String[0]), null, "TAC008");
            ++nrErrors;
        }
        DatabaseMeta refConnectionDatabaseMeta = this.getPipelineMeta().findDatabase(((TableCompareMeta)this.meta).getReferenceConnection(), this.variables);
        String refSchemaTable = refConnectionDatabaseMeta.getQuotedSchemaTableCombination((IVariables)this, referenceSchema, referenceTable);
        DatabaseMeta compConnectionDatabaseMeta = this.getPipelineMeta().findDatabase(((TableCompareMeta)this.meta).getReferenceConnection(), this.variables);
        String cmpSchemaTable = compConnectionDatabaseMeta.getQuotedSchemaTableCombination((IVariables)this, compareSchema, compareTable);
        if (Utils.isEmpty((CharSequence)keyFields)) {
            Object[] errorRowData2 = this.constructErrorRow(rowMeta, r, null, null, null);
            this.putError(((TableCompareData)this.data).errorRowMeta, errorRowData2, 1L, BaseMessages.getString(PKG, (String)"TableCompare.Exception.NoKeyFieldsDefined", (String[])new String[]{refSchemaTable, cmpSchemaTable}), null, "TAC007");
            ++nrErrors;
        }
        if (nrErrors > 0L) {
            result[0] = nrErrors;
            return result;
        }
        String[] keys = keyFields.split(",");
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = keys[i].trim();
        }
        String[] excluded = Utils.isEmpty((CharSequence)excludeFields) ? new String[]{} : excludeFields.split(",");
        for (int i = 0; i < excluded.length; ++i) {
            excluded[i] = excluded[i].trim();
        }
        try {
            IRowMeta refFields = ((TableCompareData)this.data).referenceDb.getTableFieldsMeta(referenceSchema, referenceTable);
            IRowMeta cmpFields = ((TableCompareData)this.data).compareDb.getTableFieldsMeta(compareSchema, compareTable);
            for (String string : excluded) {
                if (refFields.indexOfValue(string) >= 0) {
                    refFields.removeValueMeta(string);
                }
                if (cmpFields.indexOfValue(string) < 0) continue;
                cmpFields.removeValueMeta(string);
            }
            if (refFields.size() != cmpFields.size()) {
                Object[] errorRowData3 = this.constructErrorRow(rowMeta, r, null, null, null);
                this.putError(((TableCompareData)this.data).errorRowMeta, errorRowData3, 1L, BaseMessages.getString(PKG, (String)"TableCompare.Error.NumberOfFieldsIsDifferent", (String[])new String[]{refSchemaTable, Integer.toString(refFields.size()), cmpSchemaTable, Integer.toString(cmpFields.size())}), null, "TAC001");
                ++nrErrors;
            } else {
                Object[] two;
                for (String string : keys) {
                    if (refFields.indexOfValue(string) >= 0) continue;
                    if (this.getTransformMeta().isDoingErrorHandling()) {
                        Object[] errorRowData4 = this.constructErrorRow(rowMeta, r, null, null, null);
                        this.putError(((TableCompareData)this.data).errorRowMeta, errorRowData4, 1L, BaseMessages.getString(PKG, (String)"TableCompare.Error.KeyFieldWasNotFoundInReferenceTable", (String[])new String[]{string, refSchemaTable}), null, "TAC002");
                    }
                    ++nrErrors;
                }
                for (String string : keys) {
                    if (cmpFields.indexOfValue(string) >= 0) continue;
                    if (this.getTransformMeta().isDoingErrorHandling()) {
                        Object[] errorRowData2 = this.constructErrorRow(rowMeta, r, null, null, null);
                        this.putError(((TableCompareData)this.data).errorRowMeta, errorRowData2, 1L, BaseMessages.getString(PKG, (String)"TableCompare.Error.KeyFieldWasNotFoundInCompareTable", (String[])new String[]{string, refSchemaTable}), null, "TAC003");
                    }
                    ++nrErrors;
                }
                if (nrErrors > 0L) {
                    result[0] = nrErrors;
                    return result;
                }
                RowMeta keyRowMeta = new RowMeta();
                RowMeta valueRowMeta = new RowMeta();
                int[] keyNrs = new int[keys.length];
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("SELECT ");
                StringBuilder cmpSql = new StringBuilder();
                cmpSql.append("SELECT ");
                for (int i = 0; i < keys.length; ++i) {
                    if (i > 0) {
                        stringBuilder.append(", ");
                        cmpSql.append(", ");
                    }
                    keyNrs[i] = i;
                    stringBuilder.append(refConnectionDatabaseMeta.quoteField(keys[i]));
                    cmpSql.append(refConnectionDatabaseMeta.quoteField(keys[i]));
                }
                int[] valueNrs = new int[refFields.size() - keys.length];
                int valueNr = keys.length;
                int valueIndex = 0;
                for (int i = 0; i < refFields.getFieldNames().length; ++i) {
                    String field = refFields.getFieldNames()[i];
                    if (Const.indexOfString((String)field, (String[])keys) >= 0) continue;
                    stringBuilder.append(", ").append(refConnectionDatabaseMeta.quoteField(field));
                    valueRowMeta.addValueMeta(refFields.searchValueMeta(field));
                    valueNrs[valueIndex++] = valueNr++;
                }
                for (String field : cmpFields.getFieldNames()) {
                    if (Const.indexOfString((String)field, (String[])keys) >= 0) continue;
                    cmpSql.append(", ").append(compConnectionDatabaseMeta.quoteField(field));
                }
                stringBuilder.append(" FROM ").append(refSchemaTable).append(" ORDER BY ");
                cmpSql.append(" FROM ").append(cmpSchemaTable).append(" ORDER BY ");
                for (int i = 0; i < keys.length; ++i) {
                    if (i > 0) {
                        stringBuilder.append(", ");
                        cmpSql.append(", ");
                    }
                    stringBuilder.append(refConnectionDatabaseMeta.quoteField(keys[i]));
                    cmpSql.append(refConnectionDatabaseMeta.quoteField(keys[i]));
                }
                ResultSet refSet = ((TableCompareData)this.data).referenceDb.openQuery(stringBuilder.toString());
                ResultSet cmpSet = ((TableCompareData)this.data).compareDb.openQuery(cmpSql.toString());
                IRowMeta oneMeta = null;
                IRowMeta twoMeta = null;
                Object[] one = ((TableCompareData)this.data).referenceDb.getRow(refSet);
                if (one != null) {
                    this.incrementLinesInput();
                    if (oneMeta == null) {
                        oneMeta = ((TableCompareData)this.data).referenceDb.getReturnRowMeta();
                        for (String key : keys) {
                            keyRowMeta.addValueMeta(oneMeta.searchValueMeta(key));
                        }
                    }
                }
                if ((two = ((TableCompareData)this.data).compareDb.getRow(cmpSet)) != null) {
                    this.incrementLinesInput();
                    if (twoMeta == null) {
                        twoMeta = ((TableCompareData)this.data).compareDb.getReturnRowMeta();
                        if (keyRowMeta.isEmpty()) {
                            for (String key : keys) {
                                keyRowMeta.addValueMeta(twoMeta.searchValueMeta(key));
                            }
                        }
                    }
                }
                if (one != null) {
                    ++nrRecordsReference;
                }
                if (two != null) {
                    ++nrRecordsCompare;
                }
                do {
                    if (one == null && two != null) {
                        if (this.getTransformMeta().isDoingErrorHandling()) {
                            String keyDesc = this.getKeyDesc((IRowMeta)keyRowMeta, keyNrs, two);
                            Object[] errorRowData5 = this.constructErrorRow(rowMeta, r, keyDesc, null, null);
                            this.putError(((TableCompareData)this.data).errorRowMeta, errorRowData5, 1L, BaseMessages.getString(PKG, (String)"TableCompare.Error.RecordNotInReferenceFoundInCompareTable", (String[])new String[]{cmpSchemaTable, keyRowMeta.getString(two)}), null, "TAC004");
                        }
                        ++nrErrors;
                        ++nrRightErrors;
                        two = ((TableCompareData)this.data).compareDb.getRow(cmpSet);
                        if (two == null) continue;
                        ++nrRecordsCompare;
                        continue;
                    }
                    if (one != null && two == null) {
                        if (this.getTransformMeta().isDoingErrorHandling()) {
                            String keyDesc = this.getKeyDesc((IRowMeta)keyRowMeta, keyNrs, one);
                            Object[] errorRowData6 = this.constructErrorRow(rowMeta, r, keyDesc, null, null);
                            this.putError(((TableCompareData)this.data).errorRowMeta, errorRowData6, 1L, BaseMessages.getString(PKG, (String)"TableCompare.Error.RecordInReferenceNotFoundInCompareTable", (String[])new String[]{refSchemaTable, keyRowMeta.getString(one)}), null, "TAC005");
                        }
                        ++nrErrors;
                        ++nrLeftErrors;
                        one = ((TableCompareData)this.data).referenceDb.getRow(refSet);
                        if (one == null) continue;
                        ++nrRecordsReference;
                        continue;
                    }
                    if (one == null || two == null) continue;
                    int compare = oneMeta.compare(one, two, keyNrs);
                    if (compare == 0) {
                        int compareValues = oneMeta.compare(one, two, valueNrs);
                        if (compareValues != 0) {
                            if (this.getTransformMeta().isDoingErrorHandling()) {
                                for (int idx : valueNrs) {
                                    Object twoData;
                                    Object oneData;
                                    IValueMeta valueMeta = oneMeta.getValueMeta(idx);
                                    int cmp = valueMeta.compare(oneData = one[idx], twoData = two[idx]);
                                    if (cmp == 0) continue;
                                    String keyDesc = this.getKeyDesc((IRowMeta)keyRowMeta, keyNrs, one);
                                    String quote = valueMeta.isString() ? "'" : "";
                                    String referenceData = quote + valueMeta.getString(oneData) + quote;
                                    String compareData = quote + valueMeta.getString(twoData) + quote;
                                    Object[] errorRowData7 = this.constructErrorRow(rowMeta, r, keyDesc, referenceData, compareData);
                                    this.putError(((TableCompareData)this.data).errorRowMeta, errorRowData7, 1L, BaseMessages.getString(PKG, (String)"TableCompare.Error.CompareRowIsDifferentFromReference", (String[])new String[0]), valueMeta.getName(), "TAC006");
                                }
                            }
                            ++nrErrors;
                            ++nrInnerErrors;
                        }
                        if ((one = ((TableCompareData)this.data).referenceDb.getRow(refSet)) != null) {
                            ++nrRecordsReference;
                        }
                        if ((two = ((TableCompareData)this.data).compareDb.getRow(cmpSet)) == null) continue;
                        ++nrRecordsCompare;
                        continue;
                    }
                    if (compare < 0) {
                        if (this.getTransformMeta().isDoingErrorHandling()) {
                            String keyDesc = this.getKeyDesc((IRowMeta)keyRowMeta, keyNrs, one);
                            Object[] errorRowData8 = this.constructErrorRow(rowMeta, r, keyDesc, null, null);
                            this.putError(((TableCompareData)this.data).errorRowMeta, errorRowData8, 1L, BaseMessages.getString(PKG, (String)"TableCompare.Error.RecordNotInReferenceFoundInCompareTable", (String[])new String[]{cmpSchemaTable, keyRowMeta.getString(one)}), null, "TAC004");
                        }
                        ++nrErrors;
                        ++nrRightErrors;
                        one = ((TableCompareData)this.data).referenceDb.getRow(refSet);
                        if (one == null) continue;
                        ++nrRecordsReference;
                        continue;
                    }
                    if (this.getTransformMeta().isDoingErrorHandling()) {
                        String keyDesc = this.getKeyDesc((IRowMeta)keyRowMeta, keyNrs, two);
                        Object[] errorRowData9 = this.constructErrorRow(rowMeta, r, keyDesc, null, null);
                        this.putError(((TableCompareData)this.data).errorRowMeta, errorRowData9, 1L, BaseMessages.getString(PKG, (String)"TableCompare.Error.RecordInReferenceNotFoundInCompareTable", (String[])new String[]{refSchemaTable, keyRowMeta.getString(two)}), null, "TAC005");
                    }
                    ++nrErrors;
                    ++nrLeftErrors;
                    two = ((TableCompareData)this.data).compareDb.getRow(cmpSet);
                    if (two == null) continue;
                    ++nrRecordsCompare;
                } while ((one != null || two != null) && !this.isStopped());
                refSet.close();
                cmpSet.close();
            }
        }
        catch (Exception e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"TableCompare.Exception.UnexpectedErrorComparingTables", (String[])new String[]{refSchemaTable, cmpSchemaTable}), (Throwable)e);
        }
        int index = 0;
        result[index++] = nrErrors;
        result[index++] = nrRecordsReference;
        result[index++] = nrRecordsCompare;
        result[index++] = nrLeftErrors;
        result[index++] = nrInnerErrors;
        result[index++] = nrRightErrors;
        r[((TableCompareData)this.data).keyDescIndex] = null;
        r[((TableCompareData)this.data).valueReferenceIndex] = null;
        r[((TableCompareData)this.data).valueCompareIndex] = null;
        return result;
    }

    private String getKeyDesc(IRowMeta keyRowMeta, int[] keyNrs, Object[] one) throws HopException {
        StringBuilder keyDesc = new StringBuilder();
        for (int x = 0; x < keyNrs.length; ++x) {
            IValueMeta keyValueMeta = keyRowMeta.getValueMeta(x);
            Object keyValueData = one[keyNrs[x]];
            if (!keyDesc.isEmpty()) {
                keyDesc.append(" and ");
            }
            keyDesc.append(keyValueMeta.getName()).append(" = '");
            keyDesc.append(keyValueMeta.getString(keyValueData));
            keyDesc.append("'");
        }
        return keyDesc.toString();
    }

    private Object[] constructErrorRow(IRowMeta rowMeta, Object[] r, String keyField, String referenceValue, String compareValue) throws HopException {
        if (((TableCompareData)this.data).errorRowMeta == null) {
            ((TableCompareData)this.data).errorRowMeta = rowMeta.clone();
        }
        r[((TableCompareData)this.data).keyDescIndex] = keyField;
        r[((TableCompareData)this.data).valueReferenceIndex] = referenceValue;
        r[((TableCompareData)this.data).valueCompareIndex] = compareValue;
        return r;
    }

    public boolean init() {
        if (super.init()) {
            try {
                DatabaseMeta refConnectionDatabaseMeta = this.getPipelineMeta().findDatabase(((TableCompareMeta)this.meta).getReferenceConnection(), this.variables);
                if (refConnectionDatabaseMeta == null) {
                    this.logError(BaseMessages.getString(PKG, (String)"TableCompare.RefConnection.ConnectionMissing", (String[])new String[]{this.getTransformName()}));
                    return false;
                }
                ((TableCompareData)this.data).referenceDb = new Database((ILoggingObject)this, (IVariables)this, refConnectionDatabaseMeta);
                ((TableCompareData)this.data).referenceDb.connect();
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"TableCompare.Exception.UnexpectedErrorConnectingToReferenceDatabase", (String[])new String[]{((TableCompareMeta)this.meta).getReferenceConnection()}), e);
                return false;
            }
            try {
                DatabaseMeta compConnectionDatabaseMeta = this.getPipelineMeta().findDatabase(((TableCompareMeta)this.meta).getCompareConnection(), this.variables);
                if (compConnectionDatabaseMeta == null) {
                    this.logError(BaseMessages.getString(PKG, (String)"TableCompare.CompConnection.ConnectionMissing", (String[])new String[]{this.getTransformName()}));
                    return false;
                }
                ((TableCompareData)this.data).compareDb = new Database((ILoggingObject)this, (IVariables)this, compConnectionDatabaseMeta);
                ((TableCompareData)this.data).compareDb.connect();
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"TableCompare.Exception.UnexpectedErrorConnectingToCompareDatabase", (String[])new String[]{((TableCompareMeta)this.meta).getCompareConnection()}), e);
                return false;
            }
            return true;
        }
        return false;
    }

    public void dispose() {
        if (((TableCompareData)this.data).referenceDb != null) {
            ((TableCompareData)this.data).referenceDb.disconnect();
        }
        if (((TableCompareData)this.data).compareDb != null) {
            ((TableCompareData)this.data).compareDb.disconnect();
        }
        super.dispose();
    }
}

