/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.memgroupby.beam;

import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.GroupByKey;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.hop.beam.core.BeamHop;
import org.apache.hop.beam.core.HopRow;
import org.apache.hop.beam.core.fn.HopKeyValueFn;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.JsonRowMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.pipeline.transforms.memgroupby.beam.GroupByFn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupByTransform
extends PTransform<PCollection<HopRow>, PCollection<HopRow>> {
    private String transformName;
    private String rowMetaJson;
    private String[] groupFields;
    private String[] subjects;
    private String[] aggregations;
    private String[] resultFields;
    private static final Logger LOG = LoggerFactory.getLogger(GroupByTransform.class);
    private final Counter numErrors = Metrics.counter((String)"main", (String)"GroupByTransformErrors");
    private transient IRowMeta inputRowMeta;
    private transient IRowMeta groupRowMeta;
    private transient IRowMeta subjectRowMeta;

    public GroupByTransform() {
    }

    public GroupByTransform(String transformName, String rowMetaJson, String[] groupFields, String[] subjects, String[] aggregations, String[] resultFields) {
        this.transformName = transformName;
        this.rowMetaJson = rowMetaJson;
        this.groupFields = groupFields;
        this.subjects = subjects;
        this.aggregations = aggregations;
        this.resultFields = resultFields;
    }

    public PCollection<HopRow> expand(PCollection<HopRow> input) {
        try {
            if (this.inputRowMeta == null) {
                BeamHop.init();
                this.inputRowMeta = JsonRowMeta.fromJson((String)this.rowMetaJson);
                this.groupRowMeta = new RowMeta();
                for (String groupField : this.groupFields) {
                    this.groupRowMeta.addValueMeta(this.inputRowMeta.searchValueMeta(groupField));
                }
                this.subjectRowMeta = new RowMeta();
                for (String subject : this.subjects) {
                    this.subjectRowMeta.addValueMeta(this.inputRowMeta.searchValueMeta(subject));
                }
            }
            PCollection groupSubjects = (PCollection)input.apply((PTransform)ParDo.of((DoFn)new HopKeyValueFn(this.rowMetaJson, this.groupFields, this.subjects, this.transformName)));
            GroupByKey byKey = GroupByKey.create();
            PCollection grouped = (PCollection)groupSubjects.apply((PTransform)byKey);
            String counterName = this.transformName + " AGG";
            PCollection output = (PCollection)grouped.apply((PTransform)ParDo.of((DoFn)new GroupByFn(counterName, JsonRowMeta.toJson((IRowMeta)this.groupRowMeta), JsonRowMeta.toJson((IRowMeta)this.subjectRowMeta), this.aggregations)));
            return output;
        }
        catch (Exception e) {
            this.numErrors.inc();
            LOG.error("Error in group by transform", (Throwable)e);
            throw new RuntimeException("Error in group by transform", e);
        }
    }

    public String getRowMetaJson() {
        return this.rowMetaJson;
    }

    public void setRowMetaJson(String rowMetaJson) {
        this.rowMetaJson = rowMetaJson;
    }

    public String[] getGroupFields() {
        return this.groupFields;
    }

    public void setGroupFields(String[] groupFields) {
        this.groupFields = groupFields;
    }

    public String[] getSubjects() {
        return this.subjects;
    }

    public void setSubjects(String[] subjects) {
        this.subjects = subjects;
    }

    public String[] getAggregations() {
        return this.aggregations;
    }

    public void setAggregations(String[] aggregations) {
        this.aggregations = aggregations;
    }

    public String[] getResultFields() {
        return this.resultFields;
    }

    public void setResultFields(String[] resultFields) {
        this.resultFields = resultFields;
    }
}

