/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.execution.sampler.plugins.last;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hop.core.Const;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowBuffer;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.execution.ExecutionDataSetMeta;
import org.apache.hop.execution.sampler.ExecutionDataSamplerMeta;
import org.apache.hop.execution.sampler.ExecutionDataSamplerStoreBase;
import org.apache.hop.execution.sampler.IExecutionDataSamplerStore;
import org.apache.hop.execution.sampler.plugins.last.LastRowsExecutionDataSampler;

public class LastRowsExecutionDataSamplerStore
extends ExecutionDataSamplerStoreBase<LastRowsExecutionDataSamplerStore>
implements IExecutionDataSamplerStore {
    public static final String EXECUTION_DATA_SAMPLE_LAST_OUTPUT = "LastOutput";
    private LastRowsExecutionDataSampler dataSampler;

    public LastRowsExecutionDataSamplerStore(LastRowsExecutionDataSampler dataSampler, ExecutionDataSamplerMeta samplerMeta, IRowMeta rowMeta, List<Object[]> rows, int maxRows) {
        super(samplerMeta, rowMeta, rows, maxRows);
        this.dataSampler = dataSampler;
    }

    public LastRowsExecutionDataSamplerStore(LastRowsExecutionDataSampler dataSampler, ExecutionDataSamplerMeta samplerMeta) {
        this(dataSampler, samplerMeta, null, null, 0);
    }

    @Override
    public LastRowsExecutionDataSamplerStore getStore() {
        return this;
    }

    @Override
    public void init(IVariables variables, IRowMeta inputRowMeta, IRowMeta outputRowMeta) {
        this.rows = Collections.synchronizedList(new LinkedList());
        this.maxRows = Const.toInt((String)variables.resolve(this.dataSampler.getSampleSize()), (int)0);
    }

    @Override
    public Map<String, RowBuffer> getSamples() {
        return Map.of(this.getKeyForStore(EXECUTION_DATA_SAMPLE_LAST_OUTPUT, this.samplerMeta), new RowBuffer(this.rowMeta, this.rows));
    }

    @Override
    public Map<String, ExecutionDataSetMeta> getSamplesMetadata() {
        String setKey = this.getKeyForStore(EXECUTION_DATA_SAMPLE_LAST_OUTPUT, this.samplerMeta);
        String description = "Last rows of " + this.getSamplerMeta().getTransformName() + "." + this.getSamplerMeta().getCopyNr();
        ExecutionDataSetMeta meta = new ExecutionDataSetMeta(setKey, this.samplerMeta.getLogChannelId(), this.samplerMeta.getTransformName(), this.samplerMeta.getCopyNr(), description);
        return Map.of(setKey, meta);
    }

    public LastRowsExecutionDataSampler getDataSampler() {
        return this.dataSampler;
    }

    public void setDataSampler(LastRowsExecutionDataSampler dataSampler) {
        this.dataSampler = dataSampler;
    }
}

