/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.hudi.utilities.sources.processor;

import org.apache.hudi.common.config.TypedProperties;

import org.apache.spark.api.java.JavaRDD;

import java.io.Serializable;

/**
 * Base class for Json kafka source post processor. User can define their own processor that extends this class to do
 * some post process on the incoming json string records before the records are converted to DataSet<T>.
 */
public abstract class JsonKafkaSourcePostProcessor implements Serializable {

  protected TypedProperties props;

  public JsonKafkaSourcePostProcessor(TypedProperties props) {
    this.props = props;
  }

  public abstract JavaRDD<String> process(JavaRDD<String> inputJsonRecords);
}
