/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.bsp;

import java.util.List;
import org.apache.hugegraph.computer.core.bsp.BspClient;
import org.apache.hugegraph.computer.core.bsp.EtcdClient;
import org.apache.hugegraph.computer.core.config.ComputerOptions;
import org.apache.hugegraph.computer.core.config.Config;
import org.apache.hugegraph.config.TypedOption;

public final class EtcdBspClient
implements BspClient {
    private final String endpoints;
    private EtcdClient etcdClient;

    public EtcdBspClient(Config config) {
        this.endpoints = (String)config.get((TypedOption)ComputerOptions.BSP_ETCD_ENDPOINTS);
    }

    @Override
    public String type() {
        return "etcd";
    }

    @Override
    public String endpoint() {
        return this.endpoints;
    }

    @Override
    public void init(String namespace) {
        this.etcdClient = new EtcdClient(this.endpoints, namespace);
    }

    @Override
    public void close() {
        this.etcdClient.close();
    }

    @Override
    public void clean() {
        this.etcdClient.deleteAllKvsInNamespace();
    }

    @Override
    public void put(String key, byte[] value) {
        this.etcdClient.put(key, value);
    }

    @Override
    public byte[] get(String key) {
        return this.etcdClient.get(key);
    }

    @Override
    public byte[] get(String key, long timeout, long logInterval) {
        return this.etcdClient.get(key, timeout, logInterval);
    }

    @Override
    public List<byte[]> getChildren(String prefix, int expectedCount, long timeout, long logInterval) {
        return this.etcdClient.getWithPrefix(prefix, expectedCount, timeout, logInterval);
    }
}

