/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.output.hdfs;

import java.io.IOException;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hugegraph.computer.core.common.exception.ComputerException;
import org.apache.hugegraph.computer.core.config.ComputerOptions;
import org.apache.hugegraph.computer.core.config.Config;
import org.apache.hugegraph.computer.core.graph.vertex.Vertex;
import org.apache.hugegraph.computer.core.output.AbstractComputerOutput;
import org.apache.hugegraph.computer.core.output.hdfs.HdfsOutputMerger;
import org.apache.hugegraph.computer.core.util.StringEncoding;
import org.apache.hugegraph.config.TypedOption;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public class HdfsOutput
extends AbstractComputerOutput {
    private static final Logger LOG = Log.logger(HdfsOutput.class);
    private FileSystem fs;
    private FSDataOutputStream fileOutputStream;
    private String delimiter;
    private static final String REPLICATION_KEY = "dfs.replication";
    private static final String FILE_PREFIX = "partition_";
    private static final String FILE_SUFFIX = ".csv";

    public void init(Config config, int partition) {
        super.init(config, partition);
        try {
            Configuration configuration = new Configuration();
            Short replication = (Short)config.get((TypedOption)ComputerOptions.OUTPUT_HDFS_REPLICATION);
            configuration.set(REPLICATION_KEY, String.valueOf(replication));
            this.fs = HdfsOutput.openHDFS(config, configuration);
            this.delimiter = (String)config.get((TypedOption)ComputerOptions.OUTPUT_HDFS_DELIMITER);
            String dir = (String)config.get((TypedOption)ComputerOptions.OUTPUT_HDFS_DIR);
            String jobId = (String)config.get((TypedOption)ComputerOptions.JOB_ID);
            Path hdfsPath = HdfsOutput.buildPath(dir, jobId, partition);
            this.fileOutputStream = this.fs.create(hdfsPath, true);
        }
        catch (IOException | InterruptedException e) {
            throw new ComputerException("Failed to init hdfs output on partition [%s]", (Throwable)e, new Object[]{partition});
        }
    }

    public void write(Vertex vertex) {
        try {
            if (!this.filter(vertex)) {
                return;
            }
            this.writeString(vertex.id().toString());
            this.writeString(this.delimiter);
            this.writeString(this.constructValueString(vertex));
            this.writeString(System.lineSeparator());
        }
        catch (IOException e) {
            throw new ComputerException("Failed to write vertex: {}", new Object[]{vertex.toString(), e});
        }
    }

    protected boolean filter(Vertex vertex) {
        return true;
    }

    protected void writeBytes(byte[] bytes) throws IOException {
        this.fileOutputStream.write(bytes);
    }

    protected void writeString(String string) throws IOException {
        this.writeBytes(StringEncoding.encode(string));
    }

    protected String constructValueString(Vertex vertex) {
        return vertex.value().string();
    }

    public static Path buildPath(String dir, String jobId, int partition) {
        Path dirPath = new Path(dir, jobId);
        return new Path(dirPath, FILE_PREFIX + partition + FILE_SUFFIX);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergePartitions(Config config) {
        Boolean merge = (Boolean)config.get((TypedOption)ComputerOptions.OUTPUT_HDFS_MERGE);
        if (merge.booleanValue()) {
            LOG.info("Merge hdfs output partitions started");
            try (HdfsOutputMerger hdfsOutputMerger = new HdfsOutputMerger();){
                hdfsOutputMerger.init(config);
                hdfsOutputMerger.merge();
            }
            LOG.info("Merge hdfs output partitions finished");
        }
    }

    public void close() {
        try {
            if (this.fileOutputStream != null) {
                this.fileOutputStream.close();
            }
            if (this.fs != null) {
                this.fs.close();
            }
        }
        catch (IOException e) {
            throw new ComputerException("Failed to close hdfs", (Throwable)e);
        }
    }

    public static FileSystem openHDFS(Config config, Configuration conf) throws IOException, InterruptedException {
        String hdfsSite;
        String url = (String)config.get((TypedOption)ComputerOptions.OUTPUT_HDFS_URL);
        Boolean enableKerberos = (Boolean)config.get((TypedOption)ComputerOptions.OUTPUT_HDFS_KERBEROS_ENABLE);
        String coreSite = (String)config.get((TypedOption)ComputerOptions.OUTPUT_HDFS_CORE_SITE_PATH);
        if (StringUtils.isNotBlank((CharSequence)coreSite)) {
            conf.addResource(new Path(coreSite));
        }
        if (StringUtils.isNotBlank((CharSequence)(hdfsSite = (String)config.get((TypedOption)ComputerOptions.OUTPUT_HDFS_SITE_PATH)))) {
            conf.addResource(new Path(hdfsSite));
        }
        if (enableKerberos.booleanValue()) {
            String krb5Conf = (String)config.get((TypedOption)ComputerOptions.OUTPUT_HDFS_KRB5_CONF);
            System.setProperty("java.security.krb5.conf", krb5Conf);
            String principal = (String)config.get((TypedOption)ComputerOptions.OUTPUT_HDFS_KERBEROS_PRINCIPAL);
            String keyTab = (String)config.get((TypedOption)ComputerOptions.OUTPUT_HDFS_KERBEROS_KEYTAB);
            conf.set("fs.defaultFS", url);
            conf.set("hadoop.security.authentication", "kerberos");
            conf.set("dfs.namenode.kerberos.principal", principal);
            UserGroupInformation.setConfiguration((Configuration)conf);
            UserGroupInformation.loginUserFromKeytab((String)principal, (String)keyTab);
            return FileSystem.get((Configuration)conf);
        }
        String user = (String)config.get((TypedOption)ComputerOptions.OUTPUT_HDFS_USER);
        return FileSystem.get((URI)URI.create(url), (Configuration)conf, (String)user);
    }
}

