/*
 * Decompiled with CFR 0.152.
 */
package jflex.logging;

import java.awt.TextArea;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import jflex.exceptions.GeneratorException;
import jflex.l10n.ErrorMessages;
import jflex.logging.StdOutWriter;
import jflex.option.Options;
import jflex.performance.Timer;

public final class Out {
    public static final String NL = System.getProperty("line.separator");
    private static int warnings;
    private static int errors;
    private static StdOutWriter out;

    private Out() {
    }

    public static void setGUIMode(TextArea text) {
        out.setGUIMode(text);
    }

    public static void setOutputStream(OutputStream stream) {
        out = new StdOutWriter(stream);
        out.setGUIMode(null);
    }

    public static void time(ErrorMessages.ErrorMessage message, Timer time) {
        if (Options.time) {
            String msg = ErrorMessages.get(message, time.toString());
            out.println(msg);
        }
    }

    public static void time(String message) {
        if (Options.time) {
            out.println(message);
        }
    }

    public static void println(String message) {
        if (Options.verbose) {
            out.println(message);
        }
    }

    public static void println(ErrorMessages.ErrorMessage message, String data) {
        if (Options.verbose) {
            out.println(ErrorMessages.get(message, data));
        }
    }

    public static void println(ErrorMessages.ErrorMessage message, int data) {
        if (Options.verbose) {
            out.println(ErrorMessages.get(message, data));
        }
    }

    public static void print(String message) {
        if (Options.verbose) {
            out.print(message);
        }
    }

    public static void debug(String message) {
    }

    public static void dump(String message) {
        if (Options.dump) {
            out.println(message);
        }
    }

    public static void err(String message) {
        out.println(message);
    }

    public static void checkErrors() {
        if (errors > 0) {
            throw new GeneratorException();
        }
    }

    public static void statistics() {
        StringBuilder line = new StringBuilder(errors + " error");
        if (errors != 1) {
            line.append("s");
        }
        line.append(", ").append(warnings).append(" warning");
        if (warnings != 1) {
            line.append("s");
        }
        line.append(".");
        Out.err(line.toString());
    }

    public static void resetCounters() {
        errors = 0;
        warnings = 0;
    }

    public static void warning(String message) {
        ++warnings;
        Out.err(NL + "Warning : " + message);
    }

    public static void warning(ErrorMessages.ErrorMessage message) {
        Out.warning(message, 0);
    }

    public static void warning(ErrorMessages.ErrorMessage message, int line) {
        ++warnings;
        String msg = NL + "Warning";
        if (line > 0) {
            msg = msg + " in line " + (line + 1);
        }
        Out.err(msg + ": " + ErrorMessages.get(message));
    }

    public static void warning(File file, ErrorMessages.ErrorMessage message, int line, int column) {
        String msg = NL + "Warning";
        if (file != null) {
            msg = msg + " in file \"" + file + "\"";
        }
        if (line >= 0) {
            msg = msg + " (line " + (line + 1) + ")";
        }
        try {
            Out.err(msg + ": " + NL + ErrorMessages.get(message));
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Out.err(msg);
        }
        ++warnings;
        if (line >= 0) {
            if (column >= 0) {
                Out.showPosition(file, line, column);
            } else {
                Out.showPosition(file, line);
            }
        }
    }

    public static void error(String message) {
        ++errors;
        Out.err(NL + message);
    }

    public static void error(ErrorMessages.ErrorMessage message) {
        ++errors;
        Out.err(NL + "Error: " + ErrorMessages.get(message));
    }

    public static void error(ErrorMessages.ErrorMessage message, String data) {
        ++errors;
        Out.err(NL + "Error: " + ErrorMessages.get(message, data));
    }

    public static void error(ErrorMessages.ErrorMessage message, File file) {
        ++errors;
        Out.err(NL + "Error: " + ErrorMessages.get(message) + " (" + file + ")");
    }

    public static void error(File file, ErrorMessages.ErrorMessage message, int line, int column) {
        String msg = NL + "Error";
        if (file != null) {
            msg = msg + " in file \"" + file + "\"";
        }
        if (line >= 0) {
            msg = msg + " (line " + (line + 1) + ")";
        }
        try {
            Out.err(msg + ": " + NL + ErrorMessages.get(message));
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Out.err(msg);
        }
        ++errors;
        if (line >= 0) {
            if (column >= 0) {
                Out.showPosition(file, line, column);
            } else {
                Out.showPosition(file, line);
            }
        }
    }

    public static void showPosition(File file, int line, int column) {
        try {
            String ln = Out.getLine(file, line);
            if (ln != null) {
                Out.err(ln);
                if (column < 0) {
                    return;
                }
                String t = "^";
                for (int i = 0; i < column; ++i) {
                    t = " " + t;
                }
                Out.err(t);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void showPosition(File file, int line) {
        try {
            String ln = Out.getLine(file, line);
            if (ln != null) {
                Out.err(ln);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static String getLine(File file, int line) throws IOException {
        BufferedReader reader = Files.newBufferedReader(file.toPath(), Options.encoding);
        String msg = "";
        for (int i = 0; i <= line; ++i) {
            msg = reader.readLine();
        }
        reader.close();
        return msg;
    }

    static {
        out = new StdOutWriter();
    }
}

