/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.internal.parser.v0;

import org.openjdk.jmc.flightrecorder.internal.InvalidJfrFileException;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.IArrayElementParser;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.NumberReaders;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.Offset;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.UTFStringParser;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.model.ContentTypeDescriptor;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.model.DataStructure;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.model.DataType;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.model.ValueDescriptor;
import org.openjdk.jmc.flightrecorder.internal.util.ParserToolkit;

final class ContentTypeParser
implements IArrayElementParser<ContentTypeDescriptor> {
    private final DataStructure[] dataStructures;

    public ContentTypeParser(DataStructure[] dataStructures) {
        this.dataStructures = dataStructures;
    }

    @Override
    public ContentTypeDescriptor readElement(byte[] data, Offset offset) throws InvalidJfrFileException {
        int constantPoolIndex = NumberReaders.readInt(data, offset);
        String name = UTFStringParser.readString(data, offset);
        String description = UTFStringParser.readString(data, offset);
        DataType dataType = ParserToolkit.get(DataType.values(), NumberReaders.readByte(data, offset));
        ValueDescriptor[] dataStructure = ParserToolkit.get(this.dataStructures, NumberReaders.readInt(data, offset)).getValueDescriptors();
        return new ContentTypeDescriptor(constantPoolIndex, name, description, dataType, dataStructure);
    }

    public ContentTypeDescriptor[] createArray(int length) {
        return new ContentTypeDescriptor[length];
    }
}

