/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.pd.common;

import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.TreeRangeMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.hugegraph.pd.grpc.Metapb;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphCache {
    private static final Logger log = LoggerFactory.getLogger(GraphCache.class);
    private Metapb.Graph graph;
    private AtomicBoolean initialized = new AtomicBoolean(false);
    private AtomicBoolean writing = new AtomicBoolean(false);
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private Map<Integer, AtomicBoolean> state = new ConcurrentHashMap<Integer, AtomicBoolean>();
    private Map<Integer, Metapb.Partition> partitions = new ConcurrentHashMap<Integer, Metapb.Partition>();
    private volatile RangeMap<Long, Integer> range = TreeRangeMap.create();

    public GraphCache(Metapb.Graph graph) {
        this.graph = graph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(List<Metapb.Partition> ps) {
        ConcurrentHashMap<Integer, Metapb.Partition> gps = new ConcurrentHashMap<Integer, Metapb.Partition>(ps.size(), 1.0f);
        if (!CollectionUtils.isEmpty(ps)) {
            ReentrantReadWriteLock.WriteLock lock = this.getLock().writeLock();
            try {
                lock.lock();
                for (Metapb.Partition p : ps) {
                    gps.put(p.getId(), p);
                    this.range.put(Range.closedOpen((Comparable)Long.valueOf(p.getStartKey()), (Comparable)Long.valueOf(p.getEndKey())), (Object)p.getId());
                }
            }
            catch (Exception e) {
                log.warn("init graph with error:", (Throwable)e);
            }
            finally {
                lock.unlock();
            }
        }
        this.setPartitions(gps);
    }

    public Metapb.Partition getPartition(Integer id) {
        return this.partitions.get(id);
    }

    public Metapb.Partition addPartition(Integer id, Metapb.Partition p) {
        return this.partitions.put(id, p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Metapb.Partition removePartition(Integer id) {
        Metapb.Partition p = this.partitions.get(id);
        if (p != null) {
            RangeMap<Long, Integer> range = this.getRange();
            if (Objects.equals(p.getId(), range.get((Comparable)Long.valueOf(p.getStartKey()))) && Objects.equals(p.getId(), range.get((Comparable)Long.valueOf(p.getEndKey() - 1L)))) {
                ReentrantReadWriteLock.WriteLock lock = this.getLock().writeLock();
                lock.lock();
                try {
                    range.remove((Range)range.getEntry((Comparable)Long.valueOf(p.getStartKey())).getKey());
                }
                catch (Exception e) {
                    log.warn("remove partition with error:", (Throwable)e);
                }
                finally {
                    lock.unlock();
                }
            }
        }
        return this.partitions.remove(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePartitions() {
        this.getState().clear();
        RangeMap<Long, Integer> range = this.getRange();
        ReentrantReadWriteLock.WriteLock lock = this.getLock().writeLock();
        try {
            lock.lock();
            if (range != null) {
                range.clear();
            }
        }
        catch (Exception e) {
            log.warn("remove partition with error:", (Throwable)e);
        }
        finally {
            lock.unlock();
        }
        this.getPartitions().clear();
        this.getInitialized().set(false);
    }

    public void reset() {
        this.partitions.clear();
        try {
            this.range.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean updatePartition(Metapb.Partition partition) {
        int partId = partition.getId();
        Metapb.Partition p = this.getPartition(partId);
        if (p != null && p.equals((Object)partition)) {
            return false;
        }
        ReentrantReadWriteLock.WriteLock lock = this.getLock().writeLock();
        try {
            lock.lock();
            RangeMap<Long, Integer> range = this.getRange();
            this.addPartition(partId, partition);
            try {
                if (p != null && Objects.equals(partId, range.get((Comparable)Long.valueOf(partition.getStartKey()))) && Objects.equals(partId, range.get((Comparable)Long.valueOf(partition.getEndKey() - 1L)))) {
                    range.remove((Range)range.getEntry((Comparable)Long.valueOf(partition.getStartKey())).getKey());
                }
                range.put(Range.closedOpen((Comparable)Long.valueOf(partition.getStartKey()), (Comparable)Long.valueOf(partition.getEndKey())), (Object)partId);
            }
            catch (Exception e) {
                log.warn("update partition with error:", (Throwable)e);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            lock.unlock();
        }
        return true;
    }

    public Metapb.Graph getGraph() {
        return this.graph;
    }

    public AtomicBoolean getInitialized() {
        return this.initialized;
    }

    public AtomicBoolean getWriting() {
        return this.writing;
    }

    public ReentrantReadWriteLock getLock() {
        return this.lock;
    }

    public Map<Integer, AtomicBoolean> getState() {
        return this.state;
    }

    public Map<Integer, Metapb.Partition> getPartitions() {
        return this.partitions;
    }

    public RangeMap<Long, Integer> getRange() {
        return this.range;
    }

    public void setGraph(Metapb.Graph graph) {
        this.graph = graph;
    }

    public void setInitialized(AtomicBoolean initialized) {
        this.initialized = initialized;
    }

    public void setWriting(AtomicBoolean writing) {
        this.writing = writing;
    }

    public void setLock(ReentrantReadWriteLock lock) {
        this.lock = lock;
    }

    public void setState(Map<Integer, AtomicBoolean> state) {
        this.state = state;
    }

    public void setPartitions(Map<Integer, Metapb.Partition> partitions) {
        this.partitions = partitions;
    }

    public void setRange(RangeMap<Long, Integer> range) {
        this.range = range;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GraphCache)) {
            return false;
        }
        GraphCache other = (GraphCache)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Metapb.Graph this$graph = this.getGraph();
        Metapb.Graph other$graph = other.getGraph();
        if (this$graph == null ? other$graph != null : !this$graph.equals(other$graph)) {
            return false;
        }
        AtomicBoolean this$initialized = this.getInitialized();
        AtomicBoolean other$initialized = other.getInitialized();
        if (this$initialized == null ? other$initialized != null : !this$initialized.equals(other$initialized)) {
            return false;
        }
        AtomicBoolean this$writing = this.getWriting();
        AtomicBoolean other$writing = other.getWriting();
        if (this$writing == null ? other$writing != null : !this$writing.equals(other$writing)) {
            return false;
        }
        ReentrantReadWriteLock this$lock = this.getLock();
        ReentrantReadWriteLock other$lock = other.getLock();
        if (this$lock == null ? other$lock != null : !this$lock.equals(other$lock)) {
            return false;
        }
        Map<Integer, AtomicBoolean> this$state = this.getState();
        Map<Integer, AtomicBoolean> other$state = other.getState();
        if (this$state == null ? other$state != null : !((Object)this$state).equals(other$state)) {
            return false;
        }
        Map<Integer, Metapb.Partition> this$partitions = this.getPartitions();
        Map<Integer, Metapb.Partition> other$partitions = other.getPartitions();
        if (this$partitions == null ? other$partitions != null : !((Object)this$partitions).equals(other$partitions)) {
            return false;
        }
        RangeMap<Long, Integer> this$range = this.getRange();
        RangeMap<Long, Integer> other$range = other.getRange();
        return !(this$range == null ? other$range != null : !this$range.equals(other$range));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GraphCache;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Metapb.Graph $graph = this.getGraph();
        result = result * 59 + ($graph == null ? 43 : $graph.hashCode());
        AtomicBoolean $initialized = this.getInitialized();
        result = result * 59 + ($initialized == null ? 43 : $initialized.hashCode());
        AtomicBoolean $writing = this.getWriting();
        result = result * 59 + ($writing == null ? 43 : $writing.hashCode());
        ReentrantReadWriteLock $lock = this.getLock();
        result = result * 59 + ($lock == null ? 43 : $lock.hashCode());
        Map<Integer, AtomicBoolean> $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)$state).hashCode());
        Map<Integer, Metapb.Partition> $partitions = this.getPartitions();
        result = result * 59 + ($partitions == null ? 43 : ((Object)$partitions).hashCode());
        RangeMap<Long, Integer> $range = this.getRange();
        result = result * 59 + ($range == null ? 43 : $range.hashCode());
        return result;
    }

    public String toString() {
        return "GraphCache(graph=" + String.valueOf(this.getGraph()) + ", initialized=" + String.valueOf(this.getInitialized()) + ", writing=" + String.valueOf(this.getWriting()) + ", lock=" + String.valueOf(this.getLock()) + ", state=" + String.valueOf(this.getState()) + ", partitions=" + String.valueOf(this.getPartitions()) + ", range=" + String.valueOf(this.getRange()) + ")";
    }
}

