/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.structure;

import java.util.List;
import org.apache.hugegraph.structure.BaseElement;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.type.define.HugeKeys;

public class KvElement
extends BaseElement
implements Comparable<KvElement> {
    private List<Comparable> keys;
    private List<Object> values;

    private KvElement(List<Comparable> keys, List<Object> values) {
        this.keys = keys;
        this.values = values;
    }

    public static KvElement of(List<Comparable> keys, List<Object> values) {
        return new KvElement(keys, values);
    }

    public List<Comparable> getKeys() {
        return this.keys;
    }

    public List<Object> getValues() {
        return this.values;
    }

    @Override
    public Object sysprop(HugeKeys key) {
        return null;
    }

    @Override
    public String name() {
        return null;
    }

    @Override
    public HugeType type() {
        return HugeType.KV_TYPE;
    }

    @Override
    public int compareTo(KvElement other) {
        if (this == other) {
            return 0;
        }
        if (other == null || other.keys == null) {
            return this.keys == null ? 0 : 1;
        }
        int len = Math.min(this.keys.size(), other.keys.size());
        for (int i = 0; i < len; ++i) {
            Comparable o2;
            Comparable o1 = this.keys.get(i);
            if (o1 == (o2 = other.keys.get(i))) continue;
            if (o1 == null || o2 == null) {
                return o1 == null ? -1 : 1;
            }
            int v = o1.compareTo(o2);
            if (v == 0) continue;
            return v;
        }
        return this.keys.size() - other.keys.size();
    }
}

