/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.client.query;

import com.google.protobuf.ByteString;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.hugegraph.HugeGraphSupplier;
import org.apache.hugegraph.backend.BackendColumn;
import org.apache.hugegraph.id.Id;
import org.apache.hugegraph.pd.common.PDException;
import org.apache.hugegraph.pd.common.PartitionUtils;
import org.apache.hugegraph.serializer.BinaryElementSerializer;
import org.apache.hugegraph.serializer.BytesBuffer;
import org.apache.hugegraph.store.HgKvIterator;
import org.apache.hugegraph.store.client.HgStoreNodePartitioner;
import org.apache.hugegraph.store.client.query.CommonKvStreamObserver;
import org.apache.hugegraph.store.client.query.MultiStreamIterator;
import org.apache.hugegraph.store.client.query.QueryV2Client;
import org.apache.hugegraph.store.client.query.ResultState;
import org.apache.hugegraph.store.client.query.StreamFinalAggregationIterator;
import org.apache.hugegraph.store.client.query.StreamKvIterator;
import org.apache.hugegraph.store.client.query.StreamLimitIterator;
import org.apache.hugegraph.store.client.query.StreamSampleIterator;
import org.apache.hugegraph.store.client.query.StreamSortedIterator;
import org.apache.hugegraph.store.client.query.StreamStrictOrderIterator;
import org.apache.hugegraph.store.grpc.common.Kv;
import org.apache.hugegraph.store.grpc.query.AggregateFunc;
import org.apache.hugegraph.store.grpc.query.AggregationType;
import org.apache.hugegraph.store.grpc.query.DeDupOption;
import org.apache.hugegraph.store.grpc.query.Index;
import org.apache.hugegraph.store.grpc.query.QueryRequest;
import org.apache.hugegraph.store.grpc.query.QueryResponse;
import org.apache.hugegraph.store.grpc.query.QueryServiceGrpc;
import org.apache.hugegraph.store.grpc.query.ScanType;
import org.apache.hugegraph.store.grpc.query.ScanTypeParam;
import org.apache.hugegraph.store.query.BaseElementComparator;
import org.apache.hugegraph.store.query.KvSerializer;
import org.apache.hugegraph.store.query.QueryTypeParam;
import org.apache.hugegraph.store.query.StoreQueryParam;
import org.apache.hugegraph.store.query.StoreQueryType;
import org.apache.hugegraph.store.query.Tuple2;
import org.apache.hugegraph.store.query.func.AggregationFunctionParam;
import org.apache.hugegraph.store.query.util.KeyUtil;
import org.apache.hugegraph.structure.BaseElement;
import org.apache.hugegraph.structure.KvElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryExecutor {
    private static final Logger log = LoggerFactory.getLogger(QueryExecutor.class);
    private final HgStoreNodePartitioner nodePartitioner;
    private static final QueryV2Client client = new QueryV2Client();
    private static final BinaryElementSerializer serializer = new BinaryElementSerializer();
    private final HugeGraphSupplier supplier;
    private long timeout = 60000L;
    private static final ThreadLocal<String> filterStore = new ThreadLocal();

    public QueryExecutor(HgStoreNodePartitioner nodePartitioner, HugeGraphSupplier supplier, Long timeout) {
        this.nodePartitioner = nodePartitioner;
        this.supplier = supplier;
        this.timeout = timeout;
    }

    public List<HgKvIterator<BaseElement>> getIterators(StoreQueryParam query) throws PDException {
        HgKvIterator iterator;
        if (this.isSimpleQuery(query)) {
            return this.getSimpleIterator(query);
        }
        List<HgKvIterator<Object>> iterators = this.isSimpleCountQuery(query) ? this.getCountIterator(query) : this.getNodeTasks(query).parallelStream().map(tuple -> this.getIterator((String)tuple.getV1(), ((QueryRequest.Builder)tuple.getV2()).build())).collect(Collectors.toList());
        if (QueryExecutor.isEmpty(query.getFuncList()) && QueryExecutor.isEmpty(query.getOrderBy()) && query.getLimit() == 0) {
            return iterators;
        }
        if (!QueryExecutor.isEmpty(query.getFuncList())) {
            iterator = new StreamSortedIterator(iterators, (o1, o2) -> {
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 != null && o2 != null) {
                    if (o1 instanceof KvElement && o2 instanceof KvElement) {
                        return ((KvElement)o1).compareTo((KvElement)o2);
                    }
                    if (!(o1 instanceof KvElement)) {
                        throw new IllegalStateException("Expected KvElement but got: " + o1.getClass().getName());
                    }
                    throw new IllegalStateException("Expected KvElement but got: " + o2.getClass().getName());
                }
                return o1 != null ? 1 : -1;
            });
            iterator = new StreamFinalAggregationIterator(iterator, query.getFuncList());
            if (query.getSampleFactor() != 1.0) {
                iterator = new StreamSampleIterator(iterator, query.getSampleFactor());
            }
        } else {
            iterator = !QueryExecutor.isEmpty(query.getOrderBy()) ? (query.getSortOrder() != StoreQueryParam.SORT_ORDER.STRICT_ORDER ? new StreamSortedIterator(iterators, new BaseElementComparator(query.getOrderBy(), query.getSortOrder() == StoreQueryParam.SORT_ORDER.ASC)) : new StreamStrictOrderIterator(query.getQueryParam(), iterators, query.getGraph(), this.nodePartitioner)) : new MultiStreamIterator(iterators);
        }
        if (query.getLimit() > 0) {
            iterator = new StreamLimitIterator(iterator, query.getLimit());
        }
        return List.of(iterator);
    }

    private StreamKvIterator<BaseElement> getIterator(String address, final QueryRequest request) {
        QueryServiceGrpc.QueryServiceStub stub = client.getQueryServiceStub(address);
        final boolean hasAgg = !QueryExecutor.isEmpty(request.getFunctionsList());
        CommonKvStreamObserver observer = new CommonKvStreamObserver(response -> new Iterator<BaseElement>(){
            BaseElement element;
            final Iterator itr;
            {
                this.itr = response.getDataList().iterator();
                this.element = null;
            }

            @Override
            public boolean hasNext() {
                if (this.element == null) {
                    while (this.itr.hasNext()) {
                        this.element = QueryExecutor.this.fromKv(request.getTable(), (Kv)this.itr.next(), hasAgg);
                        if (this.element == null) continue;
                    }
                }
                return this.element != null;
            }

            @Override
            public BaseElement next() {
                try {
                    BaseElement baseElement = this.element;
                    return baseElement;
                }
                finally {
                    this.element = null;
                }
            }
        }, response -> {
            boolean finished;
            boolean ok = response.getIsOk();
            if (ok & (finished = response.getIsFinished())) {
                return ResultState.FINISHED;
            }
            if (ok & !finished) {
                return ResultState.IDLE;
            }
            if (finished) {
                return ResultState.ERROR.setMessage("server is busy");
            }
            return ResultState.ERROR.setMessage(response.getMessage());
        });
        StreamObserver reqStream = stub.query(observer);
        observer.setWatcherQueryId(request.getQueryId() + "-" + address);
        observer.setRequestSender(r -> reqStream.onNext((Object)request));
        observer.setTransferComplete(r -> reqStream.onCompleted());
        observer.setTimeout(this.timeout);
        StreamKvIterator<BaseElement> itr = new StreamKvIterator<BaseElement>(b -> observer.clear(), observer::consume);
        observer.sendRequest();
        return itr;
    }

    private static <E> boolean isEmpty(Collection<E> c) {
        return c == null || c.isEmpty();
    }

    private List<Tuple2<String, QueryRequest.Builder>> getNodeTasks(StoreQueryParam query) throws PDException {
        String graph = query.getGraph();
        List<String> stores = this.nodePartitioner.getStores(graph);
        if (stores.isEmpty()) {
            log.warn("no stores found, query: {}", (Object)query);
        }
        HashMap<String, QueryRequest.Builder> tasks = new HashMap<String, QueryRequest.Builder>();
        if (query.getQueryType() == StoreQueryType.PRIMARY_SCAN) {
            for (QueryTypeParam param : query.getQueryParam()) {
                if (param.getCode() != -1) {
                    String addr = this.nodePartitioner.partition(graph, param.getCode());
                    if (!tasks.containsKey(addr)) {
                        tasks.put(addr, QueryExecutor.fromQuery(query));
                    }
                    ((QueryRequest.Builder)tasks.get(addr)).addScanTypeParam(QueryExecutor.fromParam(query.getTable(), param));
                    continue;
                }
                for (String addr : stores) {
                    if (!tasks.containsKey(addr)) {
                        tasks.put(addr, QueryExecutor.fromQuery(query));
                    }
                    ((QueryRequest.Builder)tasks.get(addr)).addScanTypeParam(QueryExecutor.fromParam(query.getTable(), param));
                }
            }
        } else {
            for (String addr : stores) {
                tasks.computeIfAbsent(addr, t -> QueryExecutor.fromQuery(query));
            }
        }
        if (filterStore.get() != null) {
            String filterStoreStr = filterStore.get();
            return tasks.containsKey(filterStoreStr) ? List.of(Tuple2.of((Object)filterStoreStr, (Object)((QueryRequest.Builder)tasks.get(filterStoreStr)))) : List.of();
        }
        return tasks.entrySet().stream().map(entry -> Tuple2.of((Object)((String)entry.getKey()), (Object)((QueryRequest.Builder)entry.getValue()))).collect(Collectors.toList());
    }

    private static QueryRequest.Builder fromQuery(StoreQueryParam query) {
        QueryRequest.Builder builder = QueryRequest.newBuilder().setQueryId(query.getQueryId()).setGraph(query.getGraph()).setTable(query.getTable()).addAllFunctions(QueryExecutor.getAggregationProto(query.getFuncList())).addAllProperty(QueryExecutor.idToBytes(query.getProperties().getPropertyIds())).setNullProperty(query.getProperties().isEmptyId()).addAllGroupBy(QueryExecutor.idToBytes(query.getGroupBy())).addAllOrderBy(QueryExecutor.idToBytes(query.getOrderBy())).addAllHaving(QueryExecutor.getOrCreate(query.getHaving())).setScanType(ScanType.forNumber((int)query.getQueryType().ordinal())).setDedupOption(DeDupOption.forNumber((int)query.getDedupOption().ordinal())).setOffset(query.getOffset().intValue()).addAllOlapProperty(QueryExecutor.idToBytes(query.getOlapProperties())).setLoadPropertyFromIndex(query.isLoadPropertyFromIndex()).setGroupBySchemaLabel(query.isGroupBySchemaLabel());
        if (query.getSortOrder() != StoreQueryParam.SORT_ORDER.STRICT_ORDER) {
            builder.setSortOrder(query.getSortOrder() == StoreQueryParam.SORT_ORDER.ASC);
        }
        if (query.getQueryType() == StoreQueryType.INDEX_SCAN && query.getDedupOption() == StoreQueryParam.DEDUP_OPTION.NONE && !QueryExecutor.isEmpty(query.getFuncList()) && query.getFuncList().stream().allMatch(f -> f.getFunctionType() == AggregationFunctionParam.AggregationFunctionType.COUNT) && query.getConditionQuery() == null && query.getIndexes().stream().allMatch(i -> i.size() == 1 && ((QueryTypeParam)i.get(0)).isIndexScan())) {
            log.info("trans query id {} from INDEX_SCAN to NO_SCAN", (Object)query.getQueryId());
            builder.setScanType(ScanType.NO_SCAN);
        }
        if (query.getConditionQuery() != null) {
            builder.setCondition(ByteString.copyFrom((byte[])query.getConditionQuery().bytes()));
        }
        if (query.getPosition() != null) {
            builder.setPosition(ByteString.copyFrom((byte[])query.getPosition()));
        }
        builder.setSampleFactor(QueryExecutor.isEmpty(query.getFuncList()) ? query.getSampleFactor() : 1.0);
        builder.setLimit(QueryExecutor.isEmpty(query.getFuncList()) ? query.getLimit() : 0);
        if (query.getIndexes() != null) {
            builder.addAllIndexes(QueryExecutor.fromIndex(query.getIndexes()));
        }
        builder.setCheckTtl(query.isCheckTTL());
        return builder;
    }

    private static ScanTypeParam fromParam(String table, QueryTypeParam param) {
        ScanTypeParam.Builder builder = ScanTypeParam.newBuilder().setKeyStart(ByteString.copyFrom((byte[])param.getStart())).setScanBoundary(param.getBoundary()).setIsPrefix(param.isPrefix()).setIsSecondaryIndex(param.isSecondaryIndex());
        if (param.getEnd() != null) {
            builder.setKeyEnd(ByteString.copyFrom((byte[])param.getEnd()));
        }
        if (param.isIdScan() && param.getCode() == -1) {
            builder.setCode(PartitionUtils.calcHashcode((byte[])KeyUtil.getOwnerKey((String)table, (byte[])param.getStart())));
        } else {
            builder.setCode(param.getCode());
        }
        if (param.getIdPrefix() != null) {
            builder.setIdPrefix(ByteString.copyFrom((byte[])param.getIdPrefix()));
        }
        return builder.build();
    }

    private static List<ScanTypeParam> fromParams(String table, List<QueryTypeParam> params) {
        if (QueryExecutor.isEmpty(params)) {
            return new ArrayList<ScanTypeParam>();
        }
        return params.stream().map(p -> QueryExecutor.fromParam(table, p)).collect(Collectors.toList());
    }

    private static List<Index> fromIndex(List<List<QueryTypeParam>> indexes) {
        return indexes.stream().map(x -> Index.newBuilder().addAllParams(QueryExecutor.fromParams("", x)).build()).collect(Collectors.toList());
    }

    private static List<AggregateFunc> getAggregationProto(List<AggregationFunctionParam> aggParams) {
        if (QueryExecutor.isEmpty(aggParams)) {
            return new ArrayList<AggregateFunc>();
        }
        return aggParams.stream().map(param -> {
            AggregateFunc.Builder builder = AggregateFunc.newBuilder();
            builder.setFuncType(AggregationType.forNumber((int)param.getFunctionType().ordinal()));
            if (param.getField() != null) {
                builder.setField(QueryExecutor.idToBytes(param.getField()));
            }
            if (param.getFieldType() != null) {
                builder.setType(param.getFieldType().getGenericType());
            }
            return builder.build();
        }).collect(Collectors.toList());
    }

    private static List<ByteString> idToBytes(List<Id> ids) {
        if (QueryExecutor.isEmpty(ids)) {
            return new ArrayList<ByteString>();
        }
        return ids.stream().map(QueryExecutor::idToBytes).collect(Collectors.toList());
    }

    public static ByteString idToBytes(Id id) {
        BytesBuffer buffer = BytesBuffer.allocate((int)2);
        buffer.writeId(id);
        return ByteString.copyFrom((byte[])buffer.bytes());
    }

    private static <E> List<E> getOrCreate(List<E> list) {
        if (list != null) {
            return list;
        }
        return new ArrayList();
    }

    private BaseElement fromKv(String table, Kv kv, boolean isAgg) {
        if (isAgg) {
            return KvElement.of((List)KvSerializer.fromBytes((byte[])kv.getKey().toByteArray()), (List)KvSerializer.fromObjectBytes((byte[])kv.getValue().toByteArray()));
        }
        BackendColumn backendColumn = BackendColumn.of((byte[])kv.getKey().toByteArray(), (byte[])kv.getValue().toByteArray());
        try {
            if ("g+ie".equals(table) || "g+oe".equals(table)) {
                return serializer.parseEdge(this.supplier, backendColumn, null, true);
            }
            return serializer.parseVertex(this.supplier, backendColumn, null);
        }
        catch (Exception e) {
            log.error("parse element error,", (Throwable)e);
            return null;
        }
    }

    private boolean isSimpleQuery(StoreQueryParam param) {
        if (param.getQueryType() == StoreQueryType.PRIMARY_SCAN && !param.isCheckTTL() && param.getLimit() == 0 && param.getQueryParam().stream().allMatch(QueryTypeParam::isIdScan)) {
            return QueryExecutor.isEmpty(param.getFuncList()) && QueryExecutor.isEmpty(param.getOrderBy()) && QueryExecutor.isEmpty(param.getGroupBy()) && QueryExecutor.isEmpty(param.getOlapProperties()) && !param.getProperties().needSerialize() && param.getConditionQuery() == null && param.getSampleFactor() == 1.0;
        }
        return false;
    }

    private boolean isSimpleCountQuery(StoreQueryParam param) {
        if (param.getQueryType() == StoreQueryType.TABLE_SCAN && !QueryExecutor.isEmpty(param.getFuncList())) {
            return param.getFuncList().stream().allMatch(f -> f.getFunctionType() == AggregationFunctionParam.AggregationFunctionType.COUNT) && QueryExecutor.isEmpty(param.getGroupBy()) && QueryExecutor.isEmpty(param.getOrderBy()) && param.getConditionQuery() == null && !param.isGroupBySchemaLabel() && !param.isCheckTTL();
        }
        return false;
    }

    private List<HgKvIterator<BaseElement>> getSimpleIterator(final StoreQueryParam query) throws PDException {
        return this.getNodeTasks(query).parallelStream().map(entry -> {
            QueryServiceGrpc.QueryServiceBlockingStub stub = client.getQueryServiceBlockingStub((String)entry.getV1());
            QueryResponse response = stub.query0(((QueryRequest.Builder)entry.getV2()).build());
            if (!response.getIsOk()) {
                throw new RuntimeException(response.getMessage());
            }
            final Iterator data = response.getDataList().iterator();
            return new HgKvIterator<BaseElement>(){

                @Override
                public boolean hasNext() {
                    return data.hasNext();
                }

                @Override
                public BaseElement next() {
                    return QueryExecutor.this.fromKv(query.getTable(), (Kv)data.next(), false);
                }
            };
        }).collect(Collectors.toList());
    }

    private List<HgKvIterator<BaseElement>> getCountIterator(final StoreQueryParam query) throws PDException {
        return this.getNodeTasks(query).parallelStream().map(entry -> {
            QueryServiceGrpc.QueryServiceBlockingStub stub = (QueryServiceGrpc.QueryServiceBlockingStub)client.getQueryServiceBlockingStub((String)entry.getV1()).withDeadlineAfter(3600L, TimeUnit.SECONDS);
            QueryResponse response = stub.count(((QueryRequest.Builder)entry.getV2()).build());
            if (!response.getIsOk()) {
                throw new RuntimeException(response.getMessage());
            }
            final Iterator data = response.getDataList().iterator();
            return new HgKvIterator<BaseElement>(){

                @Override
                public boolean hasNext() {
                    return data.hasNext();
                }

                @Override
                public BaseElement next() {
                    return QueryExecutor.this.fromKv(query.getTable(), (Kv)data.next(), true);
                }
            };
        }).collect(Collectors.toList());
    }
}

