/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.util;

import org.apache.tinkerpop.gremlin.process.traversal.TraversalSource;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Transaction;
import org.apache.tinkerpop.gremlin.structure.util.TransactionException;

public abstract class AbstractTransaction
implements Transaction {
    private Graph graph;

    public AbstractTransaction(Graph graph) {
        this.graph = graph;
    }

    protected abstract void doOpen();

    protected abstract void doCommit() throws TransactionException;

    protected abstract void doRollback() throws TransactionException;

    protected abstract void fireOnCommit();

    protected abstract void fireOnRollback();

    protected abstract void doReadWrite();

    protected abstract void doClose();

    @Override
    public void open() {
        if (this.isOpen()) {
            throw Transaction.Exceptions.transactionAlreadyOpen();
        }
        this.doOpen();
    }

    @Override
    public void commit() {
        this.readWrite();
        this.doCommit();
        this.fireOnCommit();
    }

    @Override
    public void rollback() {
        this.readWrite();
        this.doRollback();
        this.fireOnRollback();
    }

    @Override
    public <G extends Graph> G createThreadedTx() {
        throw Transaction.Exceptions.threadedTransactionsNotSupported();
    }

    @Override
    public <T extends TraversalSource> T begin(Class<T> traversalSourceClass) {
        return this.graph.traversal(traversalSourceClass);
    }

    @Override
    public void readWrite() {
        this.doReadWrite();
    }

    @Override
    public void close() {
        this.doClose();
    }
}

