/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.node.metrics;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.hugegraph.store.node.metrics.ProcfsReader;

class ProcfsReader {
    static final long CACHE_DURATION_MS = 100L;
    private static final Map<String, ProcfsReader> instances = new HashMap();
    private static final Object instancesLock = new Object();
    private static final Map<Path, List<String>> data = new HashMap();
    private static final Object dataLock = new Object();
    private static final Path BASE = Paths.get("/proc", "self");
    private final Path entryPath;
    private final boolean osSupport;
    long lastReadTime = -1L;

    private ProcfsReader(String entry) {
        this(BASE, entry, false);
    }

    ProcfsReader(Path base, String entry) {
        this(base, entry, true);
    }

    private ProcfsReader(Path base, String entry, boolean forceOSSupport) {
        Objects.requireNonNull(base);
        Objects.requireNonNull(entry);
        this.entryPath = base.resolve(entry);
        this.osSupport = forceOSSupport || System.getProperty("os.name").toLowerCase(Locale.ENGLISH).startsWith("linux");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ProcfsReader getInstance(String entry) {
        Objects.requireNonNull(entry);
        Object object = instancesLock;
        synchronized (object) {
            ProcfsReader reader = (ProcfsReader)instances.get(entry);
            if (reader == null) {
                reader = new ProcfsReader(entry);
                instances.put(entry, reader);
            }
            return reader;
        }
    }

    Path getEntryPath() {
        return this.entryPath;
    }

    ReadResult read() throws IOException {
        return this.read(this.currentTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ReadResult read(long currentTimeMillis) throws IOException {
        Object object = dataLock;
        synchronized (object) {
            ReadResult readResult;
            Path key = this.getEntryPath().getFileName();
            if (this.lastReadTime == -1L || this.lastReadTime + 100L < currentTimeMillis) {
                List lines = this.readPath(this.entryPath);
                this.cacheResult(key, lines);
                this.lastReadTime = this.currentTime();
                readResult = new ReadResult(lines, this.lastReadTime);
            } else {
                readResult = new ReadResult((List)data.get(key), this.lastReadTime);
            }
            return readResult;
        }
    }

    List<String> readPath(Path path) throws IOException {
        Objects.requireNonNull(path);
        if (!this.osSupport) {
            return Collections.emptyList();
        }
        return Files.readAllLines(path);
    }

    void cacheResult(Path key, List<String> lines) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(lines);
        data.put(key, lines);
    }

    long currentTime() {
        return System.currentTimeMillis();
    }
}

