/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.node.task.ttl;

import com.alipay.sofa.jraft.Status;
import com.google.protobuf.ByteString;
import com.google.protobuf.GeneratedMessageV3;
import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hugegraph.store.HgStoreEngine;
import org.apache.hugegraph.store.PartitionEngine;
import org.apache.hugegraph.store.business.BusinessHandler;
import org.apache.hugegraph.store.cmd.request.DbCompactionRequest;
import org.apache.hugegraph.store.grpc.common.TTLCleanRequest;
import org.apache.hugegraph.store.node.grpc.HgStoreNodeService;
import org.apache.hugegraph.store.node.task.ttl.RaftTaskSubmitter;
import org.apache.hugegraph.store.node.task.ttl.TaskSubmitter;
import org.apache.hugegraph.store.raft.RaftClosure;
import org.apache.hugegraph.store.raft.RaftOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RaftTaskSubmitter
extends TaskSubmitter {
    private static final Logger log = LoggerFactory.getLogger(RaftTaskSubmitter.class);

    public RaftTaskSubmitter(HgStoreNodeService service, BusinessHandler handler) {
        super(service, handler);
    }

    public Status submitClean(Integer id, String graph, String table, LinkedList<ByteString> all, AtomicBoolean state, AtomicLong tableCounter, AtomicLong partitionCounter) {
        AtomicReference result = new AtomicReference();
        try {
            TTLCleanRequest cleanRequest = TTLCleanRequest.newBuilder().addAllIds(all).setGraph(graph).setPartitionId(id.intValue()).setTable(table).build();
            tableCounter.getAndAdd(all.size());
            CountDownLatch latch = new CountDownLatch(1);
            1 c = new /* Unavailable Anonymous Inner Class!! */;
            this.service.addRaftTask((byte)22, graph, id, (GeneratedMessageV3)cleanRequest, (RaftClosure)c);
            latch.await();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return (Status)result.get();
    }

    public Status submitCompaction(Integer id) {
        DbCompactionRequest cr = new DbCompactionRequest();
        cr.setPartitionId(id.intValue());
        cr.setTableName("");
        cr.setGraphName("");
        PartitionEngine engine = HgStoreEngine.getInstance().getPartitionEngine(id);
        RaftClosure closure = status -> log.info("ttl compaction:{}, status is {}", (Object)id, (Object)status);
        RaftOperation operation = RaftOperation.create((byte)103, (Object)cr);
        engine.addRaftTask(operation, closure);
        return Status.OK();
    }
}

