/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport.messages;

import com.google.common.collect.ImmutableMap;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.QueryEvents;
import org.apache.cassandra.cql3.QueryHandler;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.transport.CBUtil;
import org.apache.cassandra.transport.Message;
import org.apache.cassandra.transport.ProtocolException;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.transport.messages.ErrorMessage;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.utils.JVMStabilityInspector;

public class QueryMessage
extends Message.Request {
    public static final Message.Codec<QueryMessage> codec = new Message.Codec<QueryMessage>(){

        @Override
        public QueryMessage decode(ByteBuf body, ProtocolVersion version) {
            String query = CBUtil.readLongString(body);
            return new QueryMessage(query, QueryOptions.codec.decode(body, version));
        }

        @Override
        public void encode(QueryMessage msg, ByteBuf dest, ProtocolVersion version) {
            CBUtil.writeLongString(msg.query, dest);
            if (version == ProtocolVersion.V1) {
                CBUtil.writeConsistencyLevel(msg.options.getConsistency(), dest);
            } else {
                QueryOptions.codec.encode(msg.options, dest, version);
            }
        }

        @Override
        public int encodedSize(QueryMessage msg, ProtocolVersion version) {
            int size = CBUtil.sizeOfLongString(msg.query);
            size = version == ProtocolVersion.V1 ? (size += CBUtil.sizeOfConsistencyLevel(msg.options.getConsistency())) : (size += QueryOptions.codec.encodedSize(msg.options, version));
            return size;
        }
    };
    public final String query;
    public final QueryOptions options;

    public QueryMessage(String query, QueryOptions options) {
        super(Message.Type.QUERY);
        this.query = query;
        this.options = options;
    }

    @Override
    protected boolean isTraceable() {
        return true;
    }

    @Override
    protected Message.Response execute(QueryState state, long queryStartNanoTime, boolean traceRequest) {
        CQLStatement statement = null;
        try {
            if (this.options.getPageSize() == 0) {
                throw new ProtocolException("The page size cannot be 0");
            }
            if (traceRequest) {
                this.traceQuery(state);
            }
            long queryStartTime = System.currentTimeMillis();
            QueryHandler queryHandler = ClientState.getCQLQueryHandler();
            statement = queryHandler.parse(this.query, state, this.options);
            ResultMessage response = queryHandler.process(statement, state, this.options, this.getCustomPayload(), queryStartNanoTime);
            QueryEvents.instance.notifyQuerySuccess(statement, this.query, this.options, state, queryStartTime, response);
            if (this.options.skipMetadata() && response instanceof ResultMessage.Rows) {
                ((ResultMessage.Rows)response).result.metadata.setSkipMetadata();
            }
            return response;
        }
        catch (Exception e) {
            QueryEvents.instance.notifyQueryFailure(statement, this.query, this.options, state, e);
            JVMStabilityInspector.inspectThrowable(e);
            if (!(e instanceof RequestValidationException) && !(e instanceof RequestExecutionException)) {
                logger.error("Unexpected error during query", (Throwable)e);
            }
            return ErrorMessage.fromException(e);
        }
    }

    private void traceQuery(QueryState state) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"query", (Object)this.query);
        if (this.options.getPageSize() > 0) {
            builder.put((Object)"page_size", (Object)Integer.toString(this.options.getPageSize()));
        }
        if (this.options.getConsistency() != null) {
            builder.put((Object)"consistency_level", (Object)this.options.getConsistency().name());
        }
        if (this.options.getSerialConsistency() != null) {
            builder.put((Object)"serial_consistency_level", (Object)this.options.getSerialConsistency().name());
        }
        Tracing.instance.begin("Execute CQL3 query", state.getClientAddress(), (Map<String, String>)builder.build());
    }

    public String toString() {
        return String.format("QUERY %s [pageSize = %d]", this.query, this.options.getPageSize());
    }
}

