/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.pd.service.interceptor;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.stereotype.Component;

@Component
public class Authentication {
    private static final Set<String> innerModules = Set.of("hg", "store", "hubble", "vermeer");

    protected <T> T authenticate(String authority, String token, Function<String, T> tokenCall, Supplier<T> call) {
        try {
            String invalidBasicInfo = "invalid basic authentication info";
            if (StringUtils.isEmpty((CharSequence)authority)) {
                throw new BadCredentialsException(invalidBasicInfo);
            }
            byte[] bytes = authority.getBytes(StandardCharsets.UTF_8);
            byte[] decode = Base64.getDecoder().decode(bytes);
            String info = new String(decode);
            int delim = info.indexOf(58);
            if (delim == -1) {
                throw new BadCredentialsException(invalidBasicInfo);
            }
            String name = info.substring(0, delim);
            if (innerModules.contains(name)) {
                return call.get();
            }
            throw new AccessDeniedException("invalid service name");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String getTokenKey(String name) {
        return "PD/TOKEN/" + name;
    }
}

