/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.job.algorithm;

import com.google.common.collect.ImmutableMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.StandardHugeGraph;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.config.CoreOptions;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.job.UserJob;
import org.apache.hugegraph.job.algorithm.AbstractAlgorithm;
import org.apache.hugegraph.job.algorithm.Algorithm;
import org.apache.hugegraph.job.algorithm.AlgorithmPool;
import org.apache.hugegraph.task.HugeTask;
import org.apache.hugegraph.traversal.algorithm.HugeTraverser;
import org.apache.hugegraph.traversal.optimize.HugeScriptTraversal;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.InsertionOrderUtil;
import org.apache.hugegraph.util.Log;
import org.apache.hugegraph.util.ParameterUtil;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.slf4j.Logger;

public class SubgraphStatAlgorithm
extends AbstractAlgorithm {
    public static final String KEY_SUBGRAPH = "subgraph";
    public static final String KEY_COPY_SCHEMA = "copy_schema";
    private static final Logger LOG = Log.logger(SubgraphStatAlgorithm.class);

    @Override
    public String name() {
        return "subgraph_stat";
    }

    @Override
    public String category() {
        return "aggregate";
    }

    @Override
    public void checkParameters(Map<String, Object> parameters) {
        SubgraphStatAlgorithm.subgraph(parameters);
    }

    /*
     * Loose catch block
     */
    @Override
    public Object call(UserJob<Object> job, Map<String, Object> parameters) {
        HugeGraph graph = this.createTempGraph(job);
        Traverser traverser = new Traverser(job);
        this.initGraph(job.graph(), graph, SubgraphStatAlgorithm.subgraph(parameters), SubgraphStatAlgorithm.copySchema(parameters));
        TempJob<Object> tmpJob = new TempJob<Object>(graph, job, job.task());
        Object object = traverser.subgraphStat(tmpJob);
        traverser.close();
        graph.clearBackend();
        try {
            graph.close();
        }
        catch (Throwable e) {
            LOG.warn("Can't close subgraph_stat temp graph {}: {}", new Object[]{graph, e.getMessage(), e});
        }
        return object;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        traverser.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    graph.clearBackend();
                    try {
                        graph.close();
                    }
                    catch (Throwable e) {
                        LOG.warn("Can't close subgraph_stat temp graph {}: {}", new Object[]{graph, e.getMessage(), e});
                    }
                    throw throwable3;
                }
            }
        }
    }

    private HugeGraph createTempGraph(UserJob<Object> job) {
        Id id = job.task().id();
        String name = "tmp_" + String.valueOf(id);
        PropertiesConfiguration config = new PropertiesConfiguration();
        config.setProperty(CoreOptions.BACKEND.name(), (Object)"memory");
        config.setProperty(CoreOptions.STORE.name(), (Object)name);
        return new StandardHugeGraph(new HugeConfig((Configuration)config));
    }

    private void initGraph(HugeGraph parent, HugeGraph graph, String script, boolean copySchema) {
        if (copySchema) {
            graph.schema().copyFrom(parent.schema());
        }
        new HugeScriptTraversal((TraversalSource)graph.traversal(), "gremlin-groovy", script, (Map<String, Object>)ImmutableMap.of(), (Map<String, String>)ImmutableMap.of()).iterate();
        graph.tx().commit();
    }

    protected static String subgraph(Map<String, Object> parameters) {
        Object subgraph = parameters.get(KEY_SUBGRAPH);
        E.checkArgument((subgraph != null ? 1 : 0) != 0, (String)"Must pass parameter '%s'", (Object[])new Object[]{KEY_SUBGRAPH});
        E.checkArgument((boolean)(subgraph instanceof String), (String)"Invalid parameter '%s', expect a String, but got %s", (Object[])new Object[]{KEY_SUBGRAPH, subgraph.getClass().getSimpleName()});
        return (String)subgraph;
    }

    protected static boolean copySchema(Map<String, Object> parameters) {
        if (!parameters.containsKey(KEY_COPY_SCHEMA)) {
            return false;
        }
        return ParameterUtil.parameterBoolean(parameters, KEY_COPY_SCHEMA);
    }

    private static class TempJob<V>
    extends UserJob<V> {
        private final UserJob<V> parent;

        public TempJob(HugeGraph graph, UserJob<V> job, HugeTask<V> task) {
            this.graph(graph);
            this.task(task);
            this.parent = job;
        }

        @Override
        public String type() {
            return "temp";
        }

        @Override
        public V execute() throws Exception {
            return null;
        }

        @Override
        public void updateProgress(int progress) {
            this.parent.updateProgress(progress);
        }
    }

    private static class Traverser
    extends AbstractAlgorithm.AlgoTraverser {
        private static final Map<String, Object> PARAMS = ImmutableMap.of((Object)"depth", (Object)10L, (Object)"degree", (Object)-1L, (Object)"sample", (Object)-1L, (Object)"top", (Object)-1L, (Object)"workers", (Object)0);

        public Traverser(UserJob<Object> job) {
            super(job);
        }

        public Object subgraphStat(UserJob<Object> job) {
            AlgorithmPool pool = AlgorithmPool.instance();
            Map results = InsertionOrderUtil.newMap();
            GraphTraversalSource g = job.graph().traversal();
            results.put("vertices_count", g.V(new Object[0]).count().next());
            results.put("edges_count", g.E(new Object[0]).count().next());
            Algorithm algo = pool.get("degree_centrality");
            ImmutableMap parameters = ImmutableMap.copyOf(PARAMS);
            results.put("degrees", algo.call(job, (Map<String, Object>)parameters));
            algo = pool.get("stress_centrality");
            results.put("stress", algo.call(job, (Map<String, Object>)parameters));
            algo = pool.get("betweenness_centrality");
            results.put("betweenness", algo.call(job, (Map<String, Object>)parameters));
            algo = pool.get("eigenvector_centrality");
            results.put("eigenvectors", algo.call(job, (Map<String, Object>)parameters));
            algo = pool.get("closeness_centrality");
            results.put("closeness", algo.call(job, (Map<String, Object>)parameters));
            results.put("page_ranks", this.pageRanks(job));
            algo = pool.get("cluster_coefficient");
            results.put("cluster_coefficient", algo.call(job, (Map<String, Object>)parameters));
            algo = pool.get("rings");
            parameters = ImmutableMap.builder().putAll(PARAMS).put((Object)"count_only", (Object)true).put((Object)"each_limit", (Object)-1L).put((Object)"limit", (Object)-1L).build();
            results.put("rings", algo.call(job, (Map<String, Object>)parameters));
            return results;
        }

        private Map<Object, Double> pageRanks(UserJob<Object> job) {
            Algorithm algo = AlgorithmPool.instance().get("page_rank");
            algo.call(job, (Map<String, Object>)ImmutableMap.of((Object)"alpha", (Object)0.15));
            Map<Object, Double> ranks = InsertionOrderUtil.newMap();
            Iterator<Vertex> vertices = job.graph().vertices(new Object[0]);
            while (vertices.hasNext()) {
                Vertex vertex = vertices.next();
                ranks.put(vertex.id(), (Double)vertex.value("r_rank"));
            }
            ranks = HugeTraverser.topN(ranks, true, -1L);
            return ranks;
        }
    }
}

