/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.memory.pool.impl;

import org.apache.hugegraph.memory.MemoryManager;
import org.apache.hugegraph.memory.allocator.NettyMemoryAllocator;
import org.apache.hugegraph.memory.pool.AbstractMemoryPool;
import org.apache.hugegraph.memory.pool.MemoryPool;
import org.apache.hugegraph.memory.pool.impl.MemoryPoolStats;
import org.apache.hugegraph.memory.pool.impl.OperatorMemoryPool;
import org.apache.hugegraph.memory.util.OutOfMemoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskMemoryPool
extends AbstractMemoryPool {
    private static final Logger LOG = LoggerFactory.getLogger(TaskMemoryPool.class);
    private static final String OPERATOR_MEMORY_POOL_NAME_PREFIX = "OperatorMemoryPool";
    private MemoryPool CURRENT_WORKING_OPERATOR_MEMORY_POOL = null;

    public TaskMemoryPool(MemoryPool parent, String poolName, MemoryManager memoryManager) {
        super(parent, poolName, MemoryPoolStats.MemoryPoolType.TASK, memoryManager);
    }

    public MemoryPool getCurrentWorkingOperatorMemoryPool() {
        return this.CURRENT_WORKING_OPERATOR_MEMORY_POOL;
    }

    @Override
    public long tryToReclaimLocalMemory(long neededBytes, MemoryPool requestingPool) {
        if (this.isClosed) {
            LOG.warn("[{}] is already closed, will abort this reclaim", (Object)this);
            return 0L;
        }
        if (this.findRootQueryPool().equals(requestingPool.findRootQueryPool())) {
            return super.tryToReclaimLocalMemoryWithoutLock(neededBytes, requestingPool);
        }
        return super.tryToReclaimLocalMemory(neededBytes, requestingPool);
    }

    @Override
    public void releaseSelf(String reason, boolean isTriggeredByOOM) {
        super.releaseSelf(reason, isTriggeredByOOM);
        this.memoryManager.removeCorrespondingTaskMemoryPool(Thread.currentThread().getName());
    }

    @Override
    public MemoryPool addChildPool(String name) {
        int count = this.children.size();
        String poolName = "OperatorMemoryPool_" + name + "_" + count + "_" + System.currentTimeMillis();
        OperatorMemoryPool operatorPool = new OperatorMemoryPool((MemoryPool)this, poolName, new NettyMemoryAllocator(this.memoryManager), this.memoryManager);
        this.children.add(operatorPool);
        this.CURRENT_WORKING_OPERATOR_MEMORY_POOL = operatorPool;
        LOG.info("TaskPool-{} added operator memory pool {}", (Object)this, (Object)operatorPool);
        return operatorPool;
    }

    @Override
    public Object tryToAcquireMemoryInternal(long bytes) {
        this.getParentPool().tryToAcquireMemoryInternal(bytes);
        return super.tryToAcquireMemoryInternal(bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long requestMemoryInternal(long bytes, MemoryPool requestingPool) throws OutOfMemoryException {
        if (this.isClosed) {
            LOG.warn("[{}] is already closed, will abort this request", (Object)this);
            return 0L;
        }
        this.memoryActionLock.lock();
        try {
            long parentRes;
            if (this.isBeingArbitrated.get()) {
                this.condition.await();
            }
            if ((parentRes = this.getParentPool().requestMemoryInternal(bytes, requestingPool)) > 0L) {
                this.stats.setAllocatedBytes(this.stats.getAllocatedBytes() + parentRes);
                this.stats.setNumExpands(this.stats.getNumExpands() + 1L);
            } else if (parentRes < 0L) {
                this.stats.setAllocatedBytes(this.stats.getAllocatedBytes() - parentRes);
                this.stats.setNumExpands(this.stats.getNumExpands() + 1L);
            }
            long l = parentRes;
            return l;
        }
        catch (InterruptedException e) {
            LOG.error("Failed to release self because ", (Throwable)e);
            Thread.currentThread().interrupt();
            long l = 0L;
            return l;
        }
        finally {
            this.memoryActionLock.unlock();
        }
    }
}

