/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.meta.managers;

import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.apache.hugegraph.HugeException;
import org.apache.hugegraph.auth.SchemaDefine;
import org.apache.hugegraph.meta.MetaDriver;
import org.apache.hugegraph.meta.lock.LockResult;
import org.apache.hugegraph.schema.SchemaElement;
import org.apache.hugegraph.util.JsonUtil;

public class AbstractMetaManager {
    protected final MetaDriver metaDriver;
    protected final String cluster;

    public AbstractMetaManager(MetaDriver metaDriver, String cluster) {
        this.metaDriver = metaDriver;
        this.cluster = cluster;
    }

    protected static String serialize(SchemaDefine.AuthElement element) {
        Map<String, Object> objectMap = element.asMap();
        return JsonUtil.toJson(objectMap);
    }

    protected static String serialize(SchemaElement element) {
        Map<String, Object> objectMap = element.asMap();
        return JsonUtil.toJson(objectMap);
    }

    protected static Map<String, Object> configMap(String config) {
        return JsonUtil.fromJson(config, Map.class);
    }

    protected <T> void listen(String key, Consumer<T> consumer) {
        this.metaDriver.listen(key, consumer);
    }

    protected <T> void listenPrefix(String prefix, Consumer<T> consumer) {
        this.metaDriver.listenPrefix(prefix, consumer);
    }

    public String getRaw(String key) {
        String result = this.metaDriver.get(key);
        return Optional.ofNullable(result).orElse("");
    }

    public void putOrDeleteRaw(String key, String val) {
        if (StringUtils.isEmpty((CharSequence)val)) {
            this.metaDriver.delete(key);
        } else {
            this.metaDriver.put(key, val);
        }
    }

    public LockResult lock(String ... keys) {
        return this.lock(30L, keys);
    }

    public LockResult lock(long ttl, String ... keys) {
        String key = String.join((CharSequence)"/", keys);
        return this.lock(key, ttl);
    }

    public LockResult lock(String key, long ttl) {
        LockResult lockResult = this.metaDriver.tryLock(key, ttl, 10L);
        if (!lockResult.lockSuccess()) {
            throw new HugeException("Failed to lock '%s'", key);
        }
        return lockResult;
    }

    public LockResult tryLock(String key) {
        return this.metaDriver.tryLock(key, 30L, 10L);
    }

    public void unlock(LockResult lockResult, String ... keys) {
        String key = String.join((CharSequence)"/", keys);
        this.unlock(key, lockResult);
    }

    public void unlock(String key, LockResult lockResult) {
        this.metaDriver.unlock(key, lockResult);
    }
}

