/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.task;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import org.apache.hugegraph.HugeException;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.HugeGraphParams;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.page.PageInfo;
import org.apache.hugegraph.backend.query.Condition;
import org.apache.hugegraph.backend.query.ConditionQuery;
import org.apache.hugegraph.backend.query.QueryResults;
import org.apache.hugegraph.backend.store.BackendStore;
import org.apache.hugegraph.config.CoreOptions;
import org.apache.hugegraph.exception.ConnectionException;
import org.apache.hugegraph.exception.NotFoundException;
import org.apache.hugegraph.iterator.ExtendableIterator;
import org.apache.hugegraph.iterator.MapperIterator;
import org.apache.hugegraph.job.EphemeralJob;
import org.apache.hugegraph.schema.PropertyKey;
import org.apache.hugegraph.schema.VertexLabel;
import org.apache.hugegraph.structure.HugeVertex;
import org.apache.hugegraph.task.HugeServerInfo;
import org.apache.hugegraph.task.HugeTask;
import org.apache.hugegraph.task.ServerInfoManager;
import org.apache.hugegraph.task.TaskCallable;
import org.apache.hugegraph.task.TaskManager;
import org.apache.hugegraph.task.TaskScheduler;
import org.apache.hugegraph.task.TaskStatus;
import org.apache.hugegraph.task.TaskTransaction;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.type.define.HugeKeys;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.slf4j.Logger;

public class StandardTaskScheduler
implements TaskScheduler {
    private static final Logger LOG = Log.logger(StandardTaskScheduler.class);
    private final HugeGraphParams graph;
    private final ServerInfoManager serverManager;
    private final ExecutorService taskExecutor;
    private final ExecutorService taskDbExecutor;
    private final Map<Id, HugeTask<?>> tasks;
    private volatile TaskTransaction taskTx;

    public StandardTaskScheduler(HugeGraphParams graph, ExecutorService taskExecutor, ExecutorService taskDbExecutor, ExecutorService serverInfoDbExecutor) {
        E.checkNotNull((Object)graph, (String)"graph");
        E.checkNotNull((Object)taskExecutor, (String)"taskExecutor");
        E.checkNotNull((Object)taskDbExecutor, (String)"dbExecutor");
        this.graph = graph;
        this.taskExecutor = taskExecutor;
        this.taskDbExecutor = taskDbExecutor;
        this.serverManager = new ServerInfoManager(graph, serverInfoDbExecutor);
        this.tasks = new ConcurrentHashMap();
        this.taskTx = null;
    }

    private static boolean sleep(long ms) {
        try {
            Thread.sleep(ms);
            return true;
        }
        catch (InterruptedException ignored) {
            return false;
        }
    }

    @Override
    public HugeGraph graph() {
        return this.graph.graph();
    }

    @Override
    public String graphName() {
        return this.graph.name();
    }

    @Override
    public String spaceGraphName() {
        return this.graph.spaceGraphName();
    }

    @Override
    public int pendingTasks() {
        return this.tasks.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TaskTransaction tx() {
        if (this.taskTx == null) {
            ServerInfoManager serverInfoManager = this.serverManager;
            synchronized (serverInfoManager) {
                if (this.taskTx == null) {
                    BackendStore store = this.graph.loadSystemStore();
                    TaskTransaction tx = new TaskTransaction(this.graph, store);
                    assert (this.taskTx == null);
                    this.taskTx = tx;
                }
            }
        }
        assert (this.taskTx != null);
        return this.taskTx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> void restoreTasks() {
        Id selfServer = this.serverManager().selfNodeId();
        ArrayList<HugeTask<V>> taskList = new ArrayList<HugeTask<V>>();
        for (TaskStatus taskStatus : TaskStatus.PENDING_STATUSES) {
            String page = this.supportsPaging() ? "" : null;
            do {
                Iterator<HugeTask<V>> iter = this.findTask(taskStatus, 500L, page);
                while (iter.hasNext()) {
                    HugeTask<V> task = iter.next();
                    if (!selfServer.equals(task.server())) continue;
                    taskList.add(task);
                }
                if (page == null) continue;
                page = PageInfo.pageInfo(iter);
            } while (page != null);
        }
        for (HugeTask hugeTask : taskList) {
            LOG.info("restore task {}", (Object)hugeTask);
            this.restore(hugeTask);
        }
        try {
            this.graph.graphTransaction().commit();
        }
        finally {
            this.graph.closeTx();
        }
    }

    private <V> Future<?> restore(HugeTask<V> task) {
        E.checkArgumentNotNull(task, (String)"Task can't be null", (Object[])new Object[0]);
        E.checkArgument((!this.tasks.containsKey(task.id()) ? 1 : 0) != 0, (String)"Task '%s' is already in the queue", (Object[])new Object[]{task.id()});
        E.checkArgument((!task.isDone() && !task.completed() ? 1 : 0) != 0, (String)"No need to restore completed task '%s' with status %s", (Object[])new Object[]{task.id(), task.status()});
        task.status(TaskStatus.RESTORING);
        task.retry();
        return this.submitTask(task);
    }

    @Override
    public <V> Future<?> schedule(HugeTask<V> task) {
        E.checkArgumentNotNull(task, (String)"Task can't be null", (Object[])new Object[0]);
        if (task.status() == TaskStatus.QUEUED) {
            return this.resubmitTask(task);
        }
        if (task.callable() instanceof EphemeralJob) {
            task.status(TaskStatus.QUEUED);
            return this.submitTask(task);
        }
        this.checkOnMasterNode("schedule");
        if (this.serverManager().onlySingleNode() && !task.computer()) {
            task.status(TaskStatus.QUEUED);
            task.server(this.serverManager().selfNodeId());
            this.save(task);
            return this.submitTask(task);
        }
        task.status(TaskStatus.SCHEDULING);
        this.save(task);
        TaskManager.instance().notifyNewTask(task);
        return task;
    }

    private <V> Future<?> submitTask(HugeTask<V> task) {
        int size = this.tasks.size() + 1;
        E.checkArgument((size <= 10000 ? 1 : 0) != 0, (String)"Pending tasks size %s has exceeded the max limit %s", (Object[])new Object[]{size, 10000});
        this.initTaskCallable(task);
        assert (!this.tasks.containsKey(task.id())) : task;
        this.tasks.put(task.id(), task);
        return this.taskExecutor.submit(task);
    }

    private <V> Future<?> resubmitTask(HugeTask<V> task) {
        E.checkArgument((task.status() == TaskStatus.QUEUED ? 1 : 0) != 0, (String)"Can't resubmit task '%s' with status %s", (Object[])new Object[]{task.id(), TaskStatus.QUEUED});
        E.checkArgument((boolean)this.tasks.containsKey(task.id()), (String)"Can't resubmit task '%s' not been submitted before", (Object[])new Object[]{task.id()});
        return this.taskExecutor.submit(task);
    }

    public <V> void initTaskCallable(HugeTask<V> task) {
        task.scheduler(this);
        TaskCallable<V> callable = task.callable();
        callable.task(task);
        callable.graph(this.graph());
        if (callable instanceof TaskCallable.SysTaskCallable) {
            ((TaskCallable.SysTaskCallable)callable).params(this.graph);
        }
    }

    @Override
    public synchronized <V> void cancel(HugeTask<V> task) {
        E.checkArgumentNotNull(task, (String)"Task can't be null", (Object[])new Object[0]);
        this.checkOnMasterNode("cancel");
        if (task.completed() || task.cancelling()) {
            return;
        }
        LOG.info("Cancel task '{}' in status {}", (Object)task.id(), (Object)task.status());
        if (task.server() == null) {
            assert (task.status().code() < TaskStatus.QUEUED.code());
            if (task.status(TaskStatus.CANCELLED)) {
                this.save(task);
                return;
            }
        } else if (task.status(TaskStatus.CANCELLING)) {
            this.save(task);
            assert (task.server() != null) : task;
            assert (this.serverManager().selfIsMaster());
            if (!task.server().equals(this.serverManager().selfNodeId())) {
                this.remove(task);
            }
            TaskManager.instance().notifyNewTask(task);
            return;
        }
        throw new HugeException("Can't cancel task '%s' in status %s", task.id(), task.status());
    }

    @Override
    public ServerInfoManager serverManager() {
        return this.serverManager;
    }

    protected synchronized void scheduleTasksOnMaster() {
        Collection<HugeServerInfo> serverInfos = this.serverManager().allServerInfos();
        String page = this.supportsPaging() ? "" : null;
        do {
            Iterator tasks = this.tasks(TaskStatus.SCHEDULING, 500L, page);
            while (tasks.hasNext()) {
                HugeTask task = tasks.next();
                if (task.server() != null) continue;
                if (!this.serverManager.selfIsMaster()) {
                    return;
                }
                HugeServerInfo server = this.serverManager().pickWorkerNode(serverInfos, task);
                if (server == null) {
                    LOG.info("The master can't find suitable servers to execute task '{}', wait for next schedule", (Object)task.id());
                    continue;
                }
                assert (server.id() != null);
                task.server(server.id());
                task.status(TaskStatus.SCHEDULED);
                this.save(task);
                server.increaseLoad(task.load());
                LOG.info("Scheduled task '{}' to server '{}'", (Object)task.id(), (Object)server.id());
            }
            if (page == null) continue;
            page = PageInfo.pageInfo(tasks);
        } while (page != null);
        this.serverManager().updateServerInfos(serverInfos);
    }

    protected void executeTasksOnWorker(Id server) {
        String page = this.supportsPaging() ? "" : null;
        do {
            Iterator tasks = this.tasks(TaskStatus.SCHEDULED, 500L, page);
            while (tasks.hasNext()) {
                HugeTask task = tasks.next();
                this.initTaskCallable(task);
                Id taskServer = task.server();
                if (taskServer == null) {
                    LOG.warn("Task '{}' may not be scheduled", (Object)task.id());
                    continue;
                }
                HugeTask<?> memTask = this.tasks.get(task.id());
                if (memTask != null) {
                    assert (memTask.status().code() > task.status().code());
                    continue;
                }
                if (!taskServer.equals(server)) continue;
                task.status(TaskStatus.QUEUED);
                this.save(task);
                this.submitTask(task);
            }
            if (page == null) continue;
            page = PageInfo.pageInfo(tasks);
        } while (page != null);
    }

    protected void cancelTasksOnWorker(Id server) {
        String page = this.supportsPaging() ? "" : null;
        do {
            Iterator tasks = this.tasks(TaskStatus.CANCELLING, 500L, page);
            while (tasks.hasNext()) {
                HugeTask<Object> task = tasks.next();
                Id taskServer = task.server();
                if (taskServer == null) {
                    LOG.warn("Task '{}' may not be scheduled", (Object)task.id());
                    continue;
                }
                if (!taskServer.equals(server)) continue;
                HugeTask<?> memTask = this.tasks.get(task.id());
                if (memTask != null) {
                    task = memTask;
                } else {
                    this.initTaskCallable(task);
                }
                boolean cancelled = task.cancel(true);
                LOG.info("Server '{}' cancel task '{}' with cancelled={}", new Object[]{server, task.id(), cancelled});
            }
            if (page == null) continue;
            page = PageInfo.pageInfo(tasks);
        } while (page != null);
    }

    @Override
    public void taskDone(HugeTask<?> task) {
        this.remove(task);
        Id selfServerId = this.serverManager().selfNodeId();
        try {
            this.serverManager().decreaseLoad(task.load());
        }
        catch (Throwable e) {
            LOG.error("Failed to decrease load for task '{}' on server '{}'", new Object[]{task.id(), selfServerId, e});
        }
        LOG.debug("Task '{}' done on server '{}'", (Object)task.id(), (Object)selfServerId);
    }

    protected void remove(HugeTask<?> task) {
        this.remove(task, false);
    }

    protected void remove(HugeTask<?> task, boolean force) {
        E.checkNotNull(task, (String)"remove task");
        HugeTask<?> delTask = this.tasks.remove(task.id());
        if (delTask != null && delTask != task) {
            LOG.warn("Task '{}' may be inconsistent status {}(expect {})", new Object[]{task.id(), task.status(), delTask.status()});
        }
        assert (force || delTask == null || delTask.completed() || delTask.cancelling() || delTask.isCancelled()) : delTask;
    }

    @Override
    public <V> void save(HugeTask<V> task) {
        LOG.debug("Saving task: {}", task);
        task.scheduler(this);
        E.checkArgumentNotNull(task, (String)"Task can't be null", (Object[])new Object[0]);
        this.call(() -> {
            HugeVertex vertex = this.tx().constructVertex(task);
            this.tx().deleteIndex(vertex);
            return this.tx().addVertex(vertex);
        });
    }

    @Override
    public void init() {
        this.call(() -> this.tx().initSchema());
    }

    @Override
    public boolean close() {
        if (!this.taskDbExecutor.isShutdown()) {
            this.call(() -> {
                try {
                    this.tx().close();
                }
                catch (ConnectionException connectionException) {
                    // empty catch block
                }
                this.graph.closeTx();
            });
        }
        return this.serverManager.close();
    }

    @Override
    public <V> HugeTask<V> task(Id id) {
        E.checkArgumentNotNull((Object)id, (String)"Parameter task id can't be null", (Object[])new Object[0]);
        HugeTask<?> task = this.tasks.get(id);
        if (task != null) {
            return task;
        }
        return this.findTask(id);
    }

    @Override
    public <V> Iterator<HugeTask<V>> tasks(List<Id> ids) {
        ArrayList<Id> taskIdsNotInMem = new ArrayList<Id>();
        ArrayList taskInMem = new ArrayList();
        for (Id id : ids) {
            HugeTask<?> task = this.tasks.get(id);
            if (task != null) {
                taskInMem.add(task);
                continue;
            }
            taskIdsNotInMem.add(id);
        }
        ExtendableIterator iterator = taskInMem.isEmpty() ? new ExtendableIterator() : new ExtendableIterator(taskInMem.iterator());
        iterator.extend(this.findTasks(taskIdsNotInMem));
        return iterator;
    }

    @Override
    public <V> Iterator<HugeTask<V>> tasks(TaskStatus status, long limit, String page) {
        if (status == null) {
            return this.findAllTask(limit, page);
        }
        return this.findTask(status, limit, page);
    }

    public <V> HugeTask<V> findTask(Id id) {
        HugeTask result = this.call(() -> {
            Iterator<Vertex> vertices = this.tx().queryTaskInfos(id);
            Vertex vertex = QueryResults.one(vertices);
            if (vertex == null) {
                return null;
            }
            return HugeTask.fromVertex(vertex);
        });
        if (result == null) {
            throw new NotFoundException("Can't find task with id '%s'", id);
        }
        return result;
    }

    public <V> Iterator<HugeTask<V>> findTasks(List<Id> ids) {
        return this.queryTask(ids);
    }

    public <V> Iterator<HugeTask<V>> findAllTask(long limit, String page) {
        return this.queryTask((Map<String, Object>)ImmutableMap.of(), limit, page);
    }

    public <V> Iterator<HugeTask<V>> findTask(TaskStatus status, long limit, String page) {
        return this.queryTask("~task_status", status.code(), limit, page);
    }

    @Override
    public <V> HugeTask<V> delete(Id id, boolean force) {
        this.checkOnMasterNode("delete");
        HugeTask<V> task = this.task(id);
        if (task != null) {
            E.checkArgument((force || task.completed() ? 1 : 0) != 0, (String)"Can't delete incomplete task '%s' in status %s, Please try to cancel the task first", (Object[])new Object[]{id, task.status()});
            this.remove(task, force);
        }
        return this.call(() -> {
            Iterator<Vertex> vertices = this.tx().queryTaskInfos(id);
            HugeVertex vertex = (HugeVertex)QueryResults.one(vertices);
            if (vertex == null) {
                return null;
            }
            HugeTask result = HugeTask.fromVertex(vertex);
            E.checkState((force || result.completed() ? 1 : 0) != 0, (String)"Can't delete incomplete task '%s' in status %s", (Object[])new Object[]{id, result.status()});
            this.tx().removeVertex(vertex);
            return result;
        });
    }

    @Override
    public <V> HugeTask<V> waitUntilTaskCompleted(Id id, long seconds) throws TimeoutException {
        return this.waitUntilTaskCompleted(id, seconds, 100L);
    }

    @Override
    public <V> HugeTask<V> waitUntilTaskCompleted(Id id) throws TimeoutException {
        long timeout = (Long)this.graph.configuration().get(CoreOptions.TASK_WAIT_TIMEOUT);
        return this.waitUntilTaskCompleted(id, timeout, 1L);
    }

    private <V> HugeTask<V> waitUntilTaskCompleted(Id id, long seconds, long intervalMs) throws TimeoutException {
        long passes = seconds * 1000L / intervalMs;
        HugeTask<V> task = null;
        long pass = 0L;
        while (true) {
            try {
                task = this.task(id);
            }
            catch (NotFoundException e) {
                if (task != null && task.completed()) {
                    assert (task.id().asLong() < 0L) : task.id();
                    StandardTaskScheduler.sleep(intervalMs);
                    return task;
                }
                throw e;
            }
            if (task.completed()) {
                StandardTaskScheduler.sleep(intervalMs);
                return task;
            }
            if (pass >= passes) break;
            StandardTaskScheduler.sleep(intervalMs);
            ++pass;
        }
        throw new TimeoutException(String.format("Task '%s' was not completed in %s seconds", id, seconds));
    }

    @Override
    public void waitUntilAllTasksCompleted(long seconds) throws TimeoutException {
        int taskSize;
        long passes = seconds * 1000L / 100L;
        long pass = 0L;
        while (true) {
            if ((taskSize = this.pendingTasks()) == 0) {
                StandardTaskScheduler.sleep(100L);
                return;
            }
            if (pass >= passes) break;
            StandardTaskScheduler.sleep(100L);
            ++pass;
        }
        throw new TimeoutException(String.format("There are still %s incomplete tasks after %s seconds", taskSize, seconds));
    }

    @Override
    public void checkRequirement(String op) {
        this.checkOnMasterNode(op);
    }

    private <V> Iterator<HugeTask<V>> queryTask(String key, Object value, long limit, String page) {
        return this.queryTask((Map<String, Object>)ImmutableMap.of((Object)key, (Object)value), limit, page);
    }

    private <V> Iterator<HugeTask<V>> queryTask(Map<String, Object> conditions, long limit, String page) {
        return (Iterator)this.call(() -> {
            ConditionQuery query = this.graph.backendStoreFeatures().supportsTaskAndServerVertex() ? new ConditionQuery(HugeType.TASK) : new ConditionQuery(HugeType.VERTEX);
            if (page != null) {
                query.page(page);
            }
            VertexLabel vl = this.graph().vertexLabel(HugeTask.P.TASK);
            query.eq(HugeKeys.LABEL, vl.id());
            for (Map.Entry entry : conditions.entrySet()) {
                PropertyKey pk = this.graph().propertyKey((String)entry.getKey());
                query.query(Condition.eq(pk.id(), entry.getValue()));
            }
            query.showHidden(true);
            if (limit != -1L) {
                query.limit(limit);
            }
            Iterator<Vertex> vertices = this.tx().queryVertices(query);
            MapperIterator tasks = new MapperIterator(vertices, HugeTask::fromVertex);
            return QueryResults.toList(tasks);
        });
    }

    private <V> Iterator<HugeTask<V>> queryTask(List<Id> ids) {
        return (Iterator)this.call(() -> {
            Object[] idArray = ids.toArray(new Id[0]);
            Iterator<Vertex> vertices = this.tx().queryTaskInfos(idArray);
            MapperIterator tasks = new MapperIterator(vertices, HugeTask::fromVertex);
            return QueryResults.toList(tasks);
        });
    }

    @Override
    public <V> V call(Runnable runnable) {
        return this.call(Executors.callable(runnable, null));
    }

    @Override
    public <V> V call(Callable<V> callable) {
        assert (!Thread.currentThread().getName().startsWith("task-db-worker")) : "can't call by itself";
        try {
            callable = new TaskManager.ContextCallable<V>(callable);
            return this.taskDbExecutor.submit(callable).get();
        }
        catch (Throwable e) {
            throw new HugeException("Failed to update/query TaskStore: %s", e, e.toString());
        }
    }

    private void checkOnMasterNode(String op) {
        if (!this.serverManager().selfIsMaster()) {
            throw new HugeException("Can't %s task on non-master server", op);
        }
    }

    private boolean supportsPaging() {
        return this.graph.backendStoreFeatures().supportsQueryByPage();
    }
}

