/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.util.collection;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.apache.hugegraph.util.collection.IntIterator;
import org.apache.hugegraph.util.collection.IntMap;
import org.apache.hugegraph.util.collection.IntSet;
import sun.misc.Unsafe;

public class IntMapByDynamicHash
implements IntMap {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final float LOAD_FACTOR = 0.75f;
    private static final int PARTITIONED_SIZE_THRESHOLD = 4096;
    private static final int NULL_VALUE = Integer.MIN_VALUE;
    private static final AtomicReferenceFieldUpdater<IntMapByDynamicHash, Entry[]> TABLE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(IntMapByDynamicHash.class, Entry[].class, "table");
    private volatile Entry[] table;
    private int[] partitionedSize;
    private volatile int size;
    private static final Entry RESIZING = new Entry(Integer.MIN_VALUE, Integer.MIN_VALUE, 1);
    private static final Entry RESIZED = new Entry(Integer.MIN_VALUE, Integer.MIN_VALUE, 2);
    private static final Entry RESIZE_SENTINEL = new Entry(Integer.MIN_VALUE, Integer.MIN_VALUE, 3);
    private static final int SIZE_BUCKETS = 7;
    private static final Unsafe UNSAFE = IntSet.UNSAFE;
    private static final long ENTRY_ARRAY_BASE;
    private static final int ENTRY_ARRAY_SHIFT;
    private static final long INT_ARRAY_BASE;
    private static final int INT_ARRAY_SHIFT;
    private static final long SIZE_OFFSET;

    public IntMapByDynamicHash(int initialCapacity) {
        long size;
        int cap;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Initial Capacity: " + initialCapacity);
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        int n = cap = (size = (long)(1.0 + (double)((float)initialCapacity / 0.75f))) >= 0x40000000L ? 0x40000000 : IntMapByDynamicHash.tableSizeFor((int)size);
        if (cap >= 4096) {
            this.partitionedSize = new int[112];
        }
        this.table = new Entry[cap + 1];
    }

    public IntMapByDynamicHash() {
        this(16);
    }

    private static void setTableAt(Object[] array, int index, Object newValue) {
        UNSAFE.putObjectVolatile(array, ((long)index << ENTRY_ARRAY_SHIFT) + ENTRY_ARRAY_BASE, newValue);
    }

    private static int tableSizeFor(int c) {
        int n = c - 1;
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        return (n |= n >>> 16) < 0 ? 1 : (n >= 0x40000000 ? 0x40000000 : n + 1);
    }

    private static long entryOffset(int index) {
        return ((long)index << ENTRY_ARRAY_SHIFT) + ENTRY_ARRAY_BASE;
    }

    private static Object tableAt(Object[] array, int index) {
        return UNSAFE.getObjectVolatile(array, IntMapByDynamicHash.entryOffset(index));
    }

    private static boolean casTableAt(Object[] array, int index, Object expected, Object newValue) {
        return UNSAFE.compareAndSwapObject(array, IntMapByDynamicHash.entryOffset(index), expected, newValue);
    }

    @Override
    public boolean put(int key, int value) {
        Object[] currentArray = this.table;
        int hash = this.hash(key);
        Entry o = (Entry)IntMapByDynamicHash.tableAt(currentArray, hash);
        if (o == null) {
            Entry newEntry = new Entry(key, value);
            this.addToSize(1);
            if (IntMapByDynamicHash.casTableAt(currentArray, hash, null, newEntry)) {
                return true;
            }
            this.addToSize(-1);
        }
        this.slowPut(key, value, (Entry[])currentArray);
        return true;
    }

    private int slowPut(int key, int value, Entry[] currentTable) {
        int length;
        Entry o;
        while (true) {
            Entry e;
            int index;
            if ((o = (Entry)IntMapByDynamicHash.tableAt(currentTable, index = this.hash(key, length = currentTable.length))) == RESIZED || o == RESIZING) {
                currentTable = this.helpWithResizeWhileCurrentIndex(currentTable, index);
                continue;
            }
            boolean found = false;
            for (e = o; e != null; e = e.getNext()) {
                int candidate = e.getKey();
                if (candidate != key) continue;
                found = true;
                break;
            }
            if (found) {
                int oldVal = e.getValue();
                Entry newEntry = new Entry(key, value, this.createReplacementChainForRemoval(o, e));
                if (!IntMapByDynamicHash.casTableAt(currentTable, index, o, newEntry)) continue;
                return oldVal;
            }
            Entry newEntry = new Entry(key, value, o);
            if (IntMapByDynamicHash.casTableAt(currentTable, index, o, newEntry)) break;
        }
        this.incrementSizeAndPossiblyResize(currentTable, length, o);
        return Integer.MIN_VALUE;
    }

    @Override
    public int get(int key) {
        Object[] currentArray = this.table;
        int hash = this.hash(key);
        Entry o = (Entry)IntMapByDynamicHash.tableAt(currentArray, hash);
        if (o == RESIZED || o == RESIZING) {
            return this.slowGet(key, (Entry[])currentArray);
        }
        for (Entry e = o; e != null; e = e.getNext()) {
            int k = e.getKey();
            if (k != key && key != k) continue;
            return e.value;
        }
        return Integer.MIN_VALUE;
    }

    private int slowGet(int key, Entry[] currentArray) {
        int length;
        int hash;
        Entry o;
        while ((o = (Entry)IntMapByDynamicHash.tableAt(currentArray, hash = this.hash(key, length = currentArray.length))) == RESIZED || o == RESIZING) {
            currentArray = this.helpWithResizeWhileCurrentIndex(currentArray, hash);
        }
        for (Entry e = o; e != null; e = e.getNext()) {
            int candidate = e.getKey();
            if (candidate != key) continue;
            return e.getValue();
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public boolean remove(int key) {
        Object[] currentTable = this.table;
        int hash = this.hash(key);
        Entry o = (Entry)IntMapByDynamicHash.tableAt(currentTable, hash);
        if (o == RESIZED || o == RESIZING) {
            return this.slowRemove(key, (Entry[])currentTable) != null;
        }
        for (Entry e = o; e != null; e = e.getNext()) {
            int candidate = e.getKey();
            if (candidate != key) continue;
            Entry replacement = this.createReplacementChainForRemoval(o, e);
            if (IntMapByDynamicHash.casTableAt(currentTable, hash, o, replacement)) {
                this.addToSize(-1);
                return true;
            }
            return this.slowRemove(key, (Entry[])currentTable) != null;
        }
        return false;
    }

    private Entry slowRemove(int key, Entry[] currentTable) {
        while (true) {
            int length;
            int index;
            Entry o;
            if ((o = (Entry)IntMapByDynamicHash.tableAt(currentTable, index = this.hash(key, length = currentTable.length))) == RESIZED || o == RESIZING) {
                currentTable = this.helpWithResizeWhileCurrentIndex(currentTable, index);
                continue;
            }
            Entry prev = null;
            for (Entry e = o; e != null; e = e.getNext()) {
                int candidate = e.getKey();
                if (candidate == key) {
                    Entry replacement = this.createReplacementChainForRemoval(o, e);
                    if (!IntMapByDynamicHash.casTableAt(currentTable, index, o, replacement)) break;
                    this.addToSize(-1);
                    return e;
                }
                prev = e;
            }
            if (prev != null) break;
        }
        return null;
    }

    @Override
    public boolean containsKey(int key) {
        return this.getEntry(key) != null;
    }

    @Override
    public IntIterator keys() {
        return new KeyIterator();
    }

    @Override
    public IntIterator values() {
        return new ValueIterator();
    }

    @Override
    public void clear() {
        ResizeContainer resizeContainer;
        Object[] currentArray = this.table;
        do {
            resizeContainer = null;
            for (int i = 0; i < currentArray.length - 1; ++i) {
                Entry o = (Entry)IntMapByDynamicHash.tableAt(currentArray, i);
                if (o == RESIZED || o == RESIZING) {
                    resizeContainer = (ResizeContainer)IntMapByDynamicHash.tableAt(currentArray, currentArray.length - 1);
                    continue;
                }
                if (o == null) continue;
                if (!IntMapByDynamicHash.casTableAt(currentArray, i, o, null)) continue;
                int removedEntries = 0;
                for (Entry e = o; e != null; e = e.getNext()) {
                    ++removedEntries;
                }
                this.addToSize(-removedEntries);
            }
            if (resizeContainer == null) continue;
            if (resizeContainer.isNotDone()) {
                this.helpWithResize((Entry[])currentArray);
                resizeContainer.waitForAllResizers();
            }
            currentArray = resizeContainer.nextArray;
        } while (resizeContainer != null);
    }

    @Override
    public int size() {
        int localSize = this.size;
        if (this.partitionedSize != null) {
            for (int i = 0; i < 7; ++i) {
                localSize += this.partitionedSize[i << 4];
            }
        }
        return localSize;
    }

    @Override
    public boolean concurrent() {
        return true;
    }

    private int hash(int key) {
        return key & this.table.length - 2;
    }

    private int hash(int key, int length) {
        return key & length - 2;
    }

    private Entry getEntry(int key) {
        int length;
        int index;
        Entry o;
        Object[] currentArray = this.table;
        while ((o = (Entry)IntMapByDynamicHash.tableAt(currentArray, index = this.hash(key, length = currentArray.length))) == RESIZED || o == RESIZING) {
            currentArray = this.helpWithResizeWhileCurrentIndex((Entry[])currentArray, index);
        }
        for (Entry e = o; e != null; e = e.getNext()) {
            int candidate = e.getKey();
            if (candidate != key) continue;
            return e;
        }
        return null;
    }

    private void addToSize(int value) {
        if (this.partitionedSize != null && this.incrementPartitionedSize(value)) {
            return;
        }
        this.incrementLocalSize(value);
    }

    private boolean incrementPartitionedSize(int value) {
        int h = (int)Thread.currentThread().getId();
        h ^= h >>> 18 ^ h >>> 12;
        if ((h = (h ^ h >>> 10) & 7) != 0) {
            int localSize;
            h = h - 1 << 4;
            long address = ((long)h << INT_ARRAY_SHIFT) + INT_ARRAY_BASE;
            while (!UNSAFE.compareAndSwapInt(this.partitionedSize, address, localSize = UNSAFE.getIntVolatile(this.partitionedSize, address), localSize + value)) {
            }
            return true;
        }
        return false;
    }

    private void incrementLocalSize(int value) {
        int localSize;
        while (!UNSAFE.compareAndSwapInt(this, SIZE_OFFSET, localSize = this.size, localSize + value)) {
        }
    }

    private Entry createReplacementChainForRemoval(Entry original, Entry toRemove) {
        if (original == toRemove) {
            return original.getNext();
        }
        Entry replacement = null;
        for (Entry e = original; e != null; e = e.getNext()) {
            if (e == toRemove) continue;
            replacement = new Entry(e.getKey(), e.getValue(), replacement);
        }
        return replacement;
    }

    private void incrementSizeAndPossiblyResize(Entry[] currentArray, int length, Entry prev) {
        int threshold;
        int localSize;
        this.addToSize(1);
        if (prev != null && (localSize = this.size()) + 1 > (threshold = (int)((float)length * 0.75f))) {
            this.resize(currentArray);
        }
    }

    private Entry[] helpWithResizeWhileCurrentIndex(Entry[] currentArray, int index) {
        Entry[] newArray = this.helpWithResize(currentArray);
        int helpCount = 0;
        while (IntMapByDynamicHash.tableAt(currentArray, index) != RESIZED) {
            newArray = this.helpWithResize(currentArray);
            if ((++helpCount & 7) != 0) continue;
            Thread.yield();
        }
        return newArray;
    }

    private void resize(Entry[] oldTable) {
        this.resize(oldTable, (oldTable.length - 1 << 1) + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void resize(Entry[] oldTable, int newSize) {
        int oldCapacity = oldTable.length;
        int end = oldCapacity - 1;
        Entry last = (Entry)IntMapByDynamicHash.tableAt(oldTable, end);
        if (this.size() < end && last == RESIZE_SENTINEL) {
            return;
        }
        if (oldCapacity >= 0x40000000) {
            throw new RuntimeException("max capacity of map exceeded");
        }
        ResizeContainer resizeContainer = null;
        boolean ownResize = false;
        if (last == null || last == RESIZE_SENTINEL) {
            Entry[] entryArray = oldTable;
            // MONITORENTER : oldTable
            if (IntMapByDynamicHash.tableAt(oldTable, end) == null) {
                IntMapByDynamicHash.setTableAt(oldTable, end, RESIZE_SENTINEL);
                if (this.partitionedSize == null && newSize >= 4096) {
                    this.partitionedSize = new int[112];
                }
                resizeContainer = new ResizeContainer(new Entry[newSize], oldTable.length - 1);
                IntMapByDynamicHash.setTableAt(oldTable, end, resizeContainer);
                ownResize = true;
            }
            // MONITOREXIT : entryArray
        }
        if (!ownResize) {
            this.helpWithResize(oldTable);
            return;
        }
        this.transfer(oldTable, resizeContainer);
        Entry[] src = this.table;
        while (!TABLE_UPDATER.compareAndSet(this, oldTable, resizeContainer.nextArray)) {
            if (src == oldTable) continue;
            this.helpWithResize(src);
        }
    }

    private void transfer(Entry[] src, ResizeContainer resizeContainer) {
        Entry[] dest = resizeContainer.nextArray;
        int j = 0;
        while (j < src.length - 1) {
            Entry o = (Entry)IntMapByDynamicHash.tableAt(src, j);
            if (o == null) {
                if (!IntMapByDynamicHash.casTableAt(src, j, null, RESIZED)) continue;
                ++j;
                continue;
            }
            if (o == RESIZED || o == RESIZING) {
                j = (j & ~(ResizeContainer.QUEUE_INCREMENT - 1)) + ResizeContainer.QUEUE_INCREMENT;
                if (resizeContainer.resizers.get() != 1) continue;
                break;
            }
            if (!IntMapByDynamicHash.casTableAt(src, j, o, RESIZING)) continue;
            for (Entry e = o; e != null; e = e.getNext()) {
                this.unconditionalCopy(dest, e);
            }
            IntMapByDynamicHash.setTableAt(src, j, RESIZED);
            ++j;
        }
        resizeContainer.decrementResizerAndNotify();
        resizeContainer.waitForAllResizers();
    }

    private Entry[] helpWithResize(Entry[] currentArray) {
        ResizeContainer resizeContainer = (ResizeContainer)IntMapByDynamicHash.tableAt(currentArray, currentArray.length - 1);
        Entry[] newTable = resizeContainer.nextArray;
        if (resizeContainer.getQueuePosition() > ResizeContainer.QUEUE_INCREMENT) {
            resizeContainer.incrementResizer();
            this.reverseTransfer(currentArray, resizeContainer);
            resizeContainer.decrementResizerAndNotify();
        }
        return newTable;
    }

    private void reverseTransfer(Entry[] src, ResizeContainer resizeContainer) {
        Entry[] dest = resizeContainer.nextArray;
        while (resizeContainer.getQueuePosition() > 0) {
            int start = resizeContainer.subtractAndGetQueuePosition();
            int end = start + ResizeContainer.QUEUE_INCREMENT;
            if (end <= 0) continue;
            if (start < 0) {
                start = 0;
            }
            int j = end - 1;
            while (j >= start) {
                Entry o = (Entry)IntMapByDynamicHash.tableAt(src, j);
                if (o == null) {
                    if (!IntMapByDynamicHash.casTableAt(src, j, null, RESIZED)) continue;
                    --j;
                    continue;
                }
                if (o == RESIZED || o == RESIZING) {
                    resizeContainer.zeroOutQueuePosition();
                    return;
                }
                if (!IntMapByDynamicHash.casTableAt(src, j, o, RESIZING)) continue;
                for (Entry e = o; e != null; e = e.getNext()) {
                    this.unconditionalCopy(dest, e);
                }
                IntMapByDynamicHash.setTableAt(src, j, RESIZED);
                --j;
            }
        }
    }

    private void unconditionalCopy(Entry[] dest, Entry toCopyEntry) {
        Object[] currentArray = dest;
        while (true) {
            int length = currentArray.length;
            int index = this.hash(toCopyEntry.getKey(), length);
            Entry o = (Entry)IntMapByDynamicHash.tableAt(currentArray, index);
            if (o == RESIZED || o == RESIZING) {
                currentArray = ((ResizeContainer)IntMapByDynamicHash.tableAt((Object[])currentArray, (int)(length - 1))).nextArray;
                continue;
            }
            Entry newEntry = o == null ? (toCopyEntry.getNext() == null ? toCopyEntry : new Entry(toCopyEntry.getKey(), toCopyEntry.getValue())) : new Entry(toCopyEntry.getKey(), toCopyEntry.getValue(), o);
            if (IntMapByDynamicHash.casTableAt(currentArray, index, o, newEntry)) break;
        }
    }

    static {
        try {
            Class<Entry[]> tableClass = Entry[].class;
            ENTRY_ARRAY_BASE = UNSAFE.arrayBaseOffset(tableClass);
            int objectArrayScale = UNSAFE.arrayIndexScale(tableClass);
            if ((objectArrayScale & objectArrayScale - 1) != 0) {
                throw new AssertionError((Object)"data type scale not a power of two");
            }
            ENTRY_ARRAY_SHIFT = 31 - Integer.numberOfLeadingZeros(objectArrayScale);
            Class<int[]> intArrayClass = int[].class;
            INT_ARRAY_BASE = UNSAFE.arrayBaseOffset(intArrayClass);
            int intArrayScale = UNSAFE.arrayIndexScale(intArrayClass);
            if ((intArrayScale & intArrayScale - 1) != 0) {
                throw new AssertionError((Object)"data type scale not a power of two");
            }
            INT_ARRAY_SHIFT = 31 - Integer.numberOfLeadingZeros(intArrayScale);
            Class<IntMapByDynamicHash> mapClass = IntMapByDynamicHash.class;
            SIZE_OFFSET = UNSAFE.objectFieldOffset(mapClass.getDeclaredField("size"));
        }
        catch (NoSuchFieldException | SecurityException e) {
            throw new AssertionError((Object)e);
        }
    }

    private final class KeyIterator
    extends HashIterator {
        private KeyIterator() {
        }

        @Override
        public int next() {
            return this.nextEntry().getKey();
        }
    }

    private final class ValueIterator
    extends HashIterator {
        private ValueIterator() {
        }

        @Override
        public int next() {
            return this.nextEntry().getValue();
        }
    }

    private abstract class HashIterator
    implements IntIterator {
        private List<IteratorState> todo;
        private IteratorState currentState;
        private Entry next;
        private int index;

        protected HashIterator() {
            this.currentState = new IteratorState(IntMapByDynamicHash.this.table);
            this.findNext();
        }

        private void findNext() {
            while (this.index < this.currentState.end) {
                Entry o = (Entry)IntMapByDynamicHash.tableAt(this.currentState.currentTable, this.index);
                if (o == RESIZED || o == RESIZING) {
                    int endResized;
                    Entry[] nextArray = IntMapByDynamicHash.this.helpWithResizeWhileCurrentIndex(this.currentState.currentTable, this.index);
                    for (endResized = this.index + 1; endResized < this.currentState.end && IntMapByDynamicHash.tableAt(this.currentState.currentTable, endResized) == RESIZED; ++endResized) {
                    }
                    if (this.todo == null) {
                        this.todo = new ArrayList<IteratorState>(4);
                    }
                    if (endResized < this.currentState.end) {
                        this.todo.add(new IteratorState(this.currentState.currentTable, endResized, this.currentState.end));
                    }
                    int powerTwoLength = this.currentState.currentTable.length - 1;
                    this.todo.add(new IteratorState(nextArray, this.index + powerTwoLength, endResized + powerTwoLength));
                    this.currentState.currentTable = nextArray;
                    this.currentState.end = endResized;
                    this.currentState.start = this.index;
                    continue;
                }
                if (o != null) {
                    this.next = o;
                    ++this.index;
                    break;
                }
                ++this.index;
            }
            if (this.next == null && this.index == this.currentState.end && this.todo != null && !this.todo.isEmpty()) {
                this.currentState = this.todo.remove(this.todo.size() - 1);
                this.index = this.currentState.start;
                this.findNext();
            }
        }

        @Override
        public final boolean hasNext() {
            return this.next != null;
        }

        final Entry nextEntry() {
            Entry e = this.next;
            if (e == null) {
                throw new NoSuchElementException();
            }
            this.next = e.getNext();
            if (this.next == null) {
                this.findNext();
            }
            return e;
        }
    }

    private static final class IteratorState {
        private Entry[] currentTable;
        private int start;
        private int end;

        private IteratorState(Entry[] currentTable) {
            this.currentTable = currentTable;
            this.end = this.currentTable.length - 1;
        }

        private IteratorState(Entry[] currentTable, int start, int end) {
            this.currentTable = currentTable;
            this.start = start;
            this.end = end;
        }
    }

    private static class Entry {
        final int key;
        volatile int value;
        volatile Entry next;
        final byte state;

        public Entry(int key, int value, byte state) {
            this.key = key;
            this.value = value;
            this.state = state;
        }

        public Entry(int key, int value) {
            this.key = key;
            this.value = value;
            this.next = null;
            this.state = 0;
        }

        public Entry(int key, int value, Entry next) {
            this.key = key;
            this.value = value;
            this.next = next;
            this.state = 0;
        }

        public int getKey() {
            return this.key;
        }

        public int getValue() {
            return this.value;
        }

        public Entry getNext() {
            return this.next;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    private static final class ResizeContainer
    extends Entry {
        private static final int QUEUE_INCREMENT = Math.min(1024, Integer.highestOneBit(IntSet.CPUS) << 4);
        private final AtomicInteger resizers = new AtomicInteger(1);
        private final Entry[] nextArray;
        private final AtomicInteger queuePosition;

        private ResizeContainer(Entry[] nextArray, int oldSize) {
            super(Integer.MIN_VALUE, Integer.MIN_VALUE, (byte)4);
            this.nextArray = nextArray;
            this.queuePosition = new AtomicInteger(oldSize);
        }

        public void incrementResizer() {
            this.resizers.incrementAndGet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void decrementResizerAndNotify() {
            int remaining = this.resizers.decrementAndGet();
            if (remaining == 0) {
                ResizeContainer resizeContainer = this;
                synchronized (resizeContainer) {
                    this.notifyAll();
                }
            }
        }

        public int getQueuePosition() {
            return this.queuePosition.get();
        }

        public int subtractAndGetQueuePosition() {
            return this.queuePosition.addAndGet(-QUEUE_INCREMENT);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForAllResizers() {
            if (this.resizers.get() > 0) {
                int i;
                for (i = 0; i < 16 && this.resizers.get() != 0; ++i) {
                }
                for (i = 0; i < 16 && this.resizers.get() != 0; ++i) {
                    Thread.yield();
                }
            }
            if (this.resizers.get() > 0) {
                ResizeContainer resizeContainer = this;
                synchronized (resizeContainer) {
                    while (this.resizers.get() > 0) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }

        public boolean isNotDone() {
            return this.resizers.get() > 0;
        }

        public void zeroOutQueuePosition() {
            this.queuePosition.set(0);
        }
    }
}

