/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugins.model;

import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.plugins.Singleton;
import org.apache.logging.log4j.plugins.model.PluginType;
import org.apache.logging.log4j.plugins.util.OrderedComparator;
import org.apache.logging.log4j.status.StatusLogger;

@Singleton
public class PluginNamespace
extends AbstractCollection<PluginType<?>> {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final String key;
    private final String name;
    private final Map<String, PluginType<?>> plugins = new LinkedHashMap();

    public PluginNamespace(String name) {
        this(name.toLowerCase(Locale.ROOT), name);
    }

    public PluginNamespace(String key, String name) {
        this.key = key;
        this.name = name;
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public int size() {
        return this.plugins.size();
    }

    @Override
    public boolean isEmpty() {
        return this.plugins.isEmpty();
    }

    public PluginType<?> get(String name) {
        return this.plugins.get(name.toLowerCase(Locale.ROOT));
    }

    public void put(PluginType<?> pluginType) {
        this.put(pluginType.getKey(), pluginType);
    }

    public void put(String key, PluginType<?> pluginType) {
        this.plugins.put(key, pluginType);
        LOGGER.trace("Put PluginNamespace[{}][{}] = {}", (Object)this.name, (Object)key, pluginType);
    }

    @Override
    public boolean add(PluginType<?> pluginType) {
        return pluginType == this.merge(pluginType.getKey(), pluginType);
    }

    public PluginType<?> merge(String key, PluginType<?> pluginType) {
        PluginType result = this.plugins.merge(key, pluginType, (lhs, rhs) -> {
            int compare = OrderedComparator.INSTANCE.compare(lhs.getPluginClass(), rhs.getPluginClass());
            LOGGER.debug("PluginNamespace merge for key {} with comparison result {}", (Object)key, (Object)compare);
            return compare <= 0 ? lhs : rhs;
        });
        LOGGER.trace("Merged PluginNamespace[{}][{}] = {}", (Object)this.name, (Object)key, (Object)result);
        return result;
    }

    public void mergeAll(PluginNamespace namespace) {
        if (namespace != null) {
            namespace.forEach(this::merge);
        }
    }

    @Override
    public Iterator<PluginType<?>> iterator() {
        return this.plugins.values().iterator();
    }

    public void forEach(BiConsumer<? super String, ? super PluginType<?>> biConsumer) {
        this.plugins.forEach(biConsumer);
    }
}

