/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata;

import java.util.Collection;
import java.util.Iterator;
import org.apache.sis.metadata.AbstractMetadata;
import org.apache.sis.metadata.MetadataStandard;
import org.apache.sis.metadata.MetadataVisitor;
import org.apache.sis.metadata.PropertyAccessor;
import org.apache.sis.metadata.ValueExistencePolicy;
import org.apache.sis.util.Emptiable;
import org.apache.sis.util.internal.CollectionsExt;
import org.opengis.util.CodeList;

final class Pruner
extends MetadataVisitor<Boolean> {
    private static final ThreadLocal<Pruner> VISITORS = ThreadLocal.withInitial(Pruner::new);
    private boolean prune;
    private boolean isEmpty;

    private Pruner() {
    }

    @Override
    final ThreadLocal<Pruner> creator() {
        return VISITORS;
    }

    static boolean isEmpty(AbstractMetadata metadata, boolean prune) {
        Pruner visitor = VISITORS.get();
        boolean p = visitor.prune;
        visitor.prune = prune;
        Boolean r = (Boolean)visitor.walk(metadata.getStandard(), metadata.getInterface(), metadata, false);
        visitor.prune = p;
        return r != null && r != false;
    }

    @Override
    MetadataVisitor.Filter preVisit(PropertyAccessor accessor) {
        this.isEmpty = true;
        return MetadataVisitor.Filter.NON_EMPTY;
    }

    @Override
    Object visit(Class<?> type, Object value) {
        boolean isEmptyMetadata = this.isEmpty;
        boolean isEmptyValue = true;
        Collection values = CollectionsExt.toCollection((Object)value);
        Iterator it = values.iterator();
        while (it.hasNext()) {
            Object element = it.next();
            if (!ValueExistencePolicy.isNullOrEmpty(element)) {
                boolean isEmptyElement = false;
                if (element instanceof AbstractMetadata) {
                    AbstractMetadata md = (AbstractMetadata)element;
                    if (this.prune) {
                        md.prune();
                    }
                    isEmptyElement = md.isEmpty();
                } else if (!this.prune && element instanceof Emptiable) {
                    isEmptyElement = ((Emptiable)element).isEmpty();
                } else if (!(element instanceof Enum) && !(element instanceof CodeList)) {
                    MetadataStandard standard = MetadataStandard.forClass(element.getClass());
                    if (standard != null) {
                        Boolean r = (Boolean)this.walk(standard, type, element, false);
                        if (r != null && !(isEmptyElement = r.booleanValue()) && element instanceof Emptiable) {
                            isEmptyElement = ((Emptiable)element).isEmpty();
                        }
                    } else if (element instanceof Number) {
                        isEmptyElement = Double.isNaN(((Number)element).doubleValue());
                    } else if (element instanceof Boolean) {
                        boolean bl = isEmptyElement = (Boolean)element == false;
                    }
                }
                if (!isEmptyElement) {
                    if (!this.prune) {
                        this.isEmpty = false;
                        return SKIP_SIBLINGS;
                    }
                    isEmptyValue = false;
                    continue;
                }
            }
            if (!this.prune || values != value) continue;
            it.remove();
        }
        this.isEmpty = isEmptyMetadata & isEmptyValue;
        return isEmptyValue & this.prune ? null : value;
    }

    @Override
    Boolean result() {
        return this.isEmpty;
    }
}

