/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.stream;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.stream.SubscriptionOption;
import com.linecorp.armeria.internal.common.stream.InternalStreamMessageUtil;
import com.linecorp.armeria.internal.common.stream.StreamMessageUtil;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableCollection;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class StreamMessageCollector<T>
implements Subscriber<T> {
    private final CompletableFuture<List<T>> future = new CompletableFuture();
    private final boolean withPooledObjects;
    @Nullable
    private ImmutableList.Builder<T> elementsBuilder = ImmutableList.builder();

    StreamMessageCollector(SubscriptionOption ... options) {
        this.withPooledObjects = InternalStreamMessageUtil.containsWithPooledObjects(options);
    }

    CompletableFuture<List<T>> collect() {
        return this.future;
    }

    public void onSubscribe(Subscription s) {
        s.request(Long.MAX_VALUE);
    }

    public void onNext(T o) {
        Objects.requireNonNull(o, "o");
        assert (this.elementsBuilder != null);
        this.elementsBuilder.add((Object)StreamMessageUtil.touchOrCopyAndClose(o, this.withPooledObjects));
    }

    public void onComplete() {
        if (this.future.isDone()) {
            return;
        }
        assert (this.elementsBuilder != null);
        this.future.complete((List<ImmutableCollection>)((Object)this.elementsBuilder.build()));
        this.elementsBuilder = null;
    }

    public void onError(Throwable t) {
        if (this.future.isDone()) {
            return;
        }
        assert (this.elementsBuilder != null);
        ImmutableCollection elements = this.elementsBuilder.build();
        for (Object element : elements) {
            StreamMessageUtil.closeOrAbort(element, t);
        }
        this.future.completeExceptionally(t);
        this.elementsBuilder = null;
    }
}

