/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basecrdt.core.internal;

import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.bifromq.basecrdt.core.api.CCounterOperation;
import org.apache.bifromq.basecrdt.core.api.CausalCRDTType;
import org.apache.bifromq.basecrdt.core.api.ICCounter;
import org.apache.bifromq.basecrdt.core.api.ICCounterInflater;
import org.apache.bifromq.basecrdt.core.internal.CCounter;
import org.apache.bifromq.basecrdt.core.internal.CCounterCoalesceOperation;
import org.apache.bifromq.basecrdt.core.internal.CausalCRDT;
import org.apache.bifromq.basecrdt.core.internal.CausalCRDTInflater;
import org.apache.bifromq.basecrdt.core.internal.DotMap;
import org.apache.bifromq.basecrdt.core.internal.ICoalesceOperation;
import org.apache.bifromq.basecrdt.core.internal.IDotMap;
import org.apache.bifromq.basecrdt.core.internal.IReplicaStateLattice;
import org.apache.bifromq.basecrdt.proto.Replica;

class CCounterInflater
extends CausalCRDTInflater<IDotMap, CCounterOperation, ICCounter>
implements ICCounterInflater {
    CCounterInflater(String storeId, Replica replica, IReplicaStateLattice stateLattice, ScheduledExecutorService executor, Duration inflationInterval, String ... tags) {
        super(storeId, replica, stateLattice, executor, inflationInterval, tags);
    }

    @Override
    protected ICCounter newCRDT(Replica replica, IDotMap dotStore, CausalCRDT.CRDTOperationExecutor<CCounterOperation> executor) {
        return new CCounter(replica, () -> dotStore, executor);
    }

    @Override
    public CausalCRDTType type() {
        return CausalCRDTType.cctr;
    }

    @Override
    protected ICoalesceOperation<IDotMap, CCounterOperation> startCoalescing(CCounterOperation op) {
        return new CCounterCoalesceOperation(this.id().getId(), op);
    }

    @Override
    protected Class<? extends IDotMap> dotStoreType() {
        return DotMap.class;
    }
}

