/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.mqtt.handler.v3;

import com.google.protobuf.ByteString;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.mqtt.MqttFixedHeader;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import io.netty.handler.codec.mqtt.MqttPublishVariableHeader;
import io.netty.handler.codec.mqtt.MqttQoS;
import java.nio.ByteBuffer;
import org.apache.bifromq.type.QoS;

public class MQTT3MessageBuilders {
    public static PublishBuilder pub() {
        return new PublishBuilder();
    }

    public static PubRecBuilder pubRec() {
        return new PubRecBuilder();
    }

    public static PubRelBuilder pubRel() {
        return new PubRelBuilder();
    }

    public static PubCompBuilder pubComp() {
        return new PubCompBuilder();
    }

    public static final class PublishBuilder {
        private String topic;
        private boolean dup;
        private boolean retained;
        private QoS qos;
        private ByteString payload;
        private int messageId;

        PublishBuilder() {
        }

        public PublishBuilder topicName(String topic) {
            this.topic = topic;
            return this;
        }

        public PublishBuilder retained(boolean retained) {
            this.retained = retained;
            return this;
        }

        public PublishBuilder dup(boolean dup) {
            this.dup = dup;
            return this;
        }

        public PublishBuilder qos(QoS qos) {
            this.qos = qos;
            return this;
        }

        public PublishBuilder payload(ByteString payload) {
            this.payload = payload;
            return this;
        }

        public PublishBuilder messageId(int messageId) {
            this.messageId = messageId;
            return this;
        }

        public MqttPublishMessage build() {
            MqttFixedHeader mqttFixedHeader = new MqttFixedHeader(MqttMessageType.PUBLISH, this.dup, MqttQoS.valueOf((int)this.qos.getNumber()), this.retained, 0);
            MqttPublishVariableHeader mqttVariableHeader = new MqttPublishVariableHeader(this.topic, this.messageId, null);
            return new MqttPublishMessage(mqttFixedHeader, mqttVariableHeader, Unpooled.wrappedBuffer((ByteBuffer)this.payload.asReadOnlyByteBuffer()));
        }
    }

    public static final class PubRecBuilder {
        private int packetId;

        PubRecBuilder() {
        }

        public PubRecBuilder packetId(int packetId) {
            this.packetId = packetId;
            return this;
        }

        public MqttMessage build() {
            MqttFixedHeader fixedHeader = new MqttFixedHeader(MqttMessageType.PUBREC, false, MqttQoS.AT_MOST_ONCE, false, 2);
            MqttMessageIdVariableHeader varHeader = MqttMessageIdVariableHeader.from((int)this.packetId);
            return new MqttMessage(fixedHeader, (Object)varHeader);
        }
    }

    public static final class PubRelBuilder {
        private int packetId;

        PubRelBuilder() {
        }

        public PubRelBuilder packetId(int packetId) {
            this.packetId = packetId;
            return this;
        }

        public MqttMessage build() {
            MqttFixedHeader fixedHeader = new MqttFixedHeader(MqttMessageType.PUBREL, false, MqttQoS.AT_LEAST_ONCE, false, 2);
            MqttMessageIdVariableHeader varHeader = MqttMessageIdVariableHeader.from((int)this.packetId);
            return new MqttMessage(fixedHeader, (Object)varHeader);
        }
    }

    public static final class PubCompBuilder {
        private int packetId;

        PubCompBuilder() {
        }

        public PubCompBuilder packetId(int packetId) {
            this.packetId = packetId;
            return this;
        }

        public MqttMessage build() {
            MqttFixedHeader fixedHeader = new MqttFixedHeader(MqttMessageType.PUBCOMP, false, MqttQoS.AT_MOST_ONCE, false, 2);
            MqttMessageIdVariableHeader varHeader = MqttMessageIdVariableHeader.from((int)this.packetId);
            return new MqttMessage(fixedHeader, (Object)varHeader);
        }
    }
}

