/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.store.range.hinter;

import com.google.common.base.Preconditions;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import java.time.Duration;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.function.Supplier;
import org.apache.bifromq.basekv.proto.Boundary;
import org.apache.bifromq.basekv.proto.SplitHint;
import org.apache.bifromq.basekv.store.range.hinter.IKVLoadRecord;
import org.apache.bifromq.basekv.store.range.hinter.IKVRangeSplitHinter;
import org.apache.bifromq.basekv.store.range.hinter.LoadRecordWindow;

public abstract class KVLoadBasedSplitHinter
implements IKVRangeSplitHinter {
    public static final String LOAD_TYPE_IO_DENSITY = "ioDensity";
    public static final String LOAD_TYPE_IO_LATENCY_NANOS = "ioLatencyNanos";
    public static final String LOAD_TYPE_AVG_LATENCY_NANOS = "avgLatencyNanos";
    private final Supplier<Long> nanoSource;
    private final long windowSizeNanos;
    private final NavigableMap<Long, LoadRecordWindow> trackedKeySlots = new ConcurrentSkipListMap<Long, LoadRecordWindow>();
    private final NavigableMap<Long, SplitHint> recentLoadHints = new ConcurrentSkipListMap<Long, SplitHint>();
    private final Gauge ioDensityGuage;
    private final Gauge ioLatencyNanosGauge;
    private final Gauge avgLatencyNanosGauge;
    private volatile SplitHint latestHint = SplitHint.getDefaultInstance();

    public KVLoadBasedSplitHinter(Supplier<Long> nanoSource, Duration windowSize, String ... tags) {
        Preconditions.checkArgument((!windowSize.isNegative() ? 1 : 0) != 0, (Object)"Window size must be positive");
        this.nanoSource = nanoSource;
        this.windowSizeNanos = windowSize.toNanos();
        this.ioDensityGuage = Gauge.builder((String)"basekv.load.est.iodensity", () -> this.latestHint.getLoadOrDefault(LOAD_TYPE_IO_DENSITY, 0.0)).tags(tags).tags(new String[]{"type", this.type()}).register((MeterRegistry)Metrics.globalRegistry);
        this.ioLatencyNanosGauge = Gauge.builder((String)"basekv.load.est.iolatency", () -> this.latestHint.getLoadOrDefault(LOAD_TYPE_IO_LATENCY_NANOS, 0.0)).tags(tags).tags(new String[]{"type", this.type()}).register((MeterRegistry)Metrics.globalRegistry);
        this.avgLatencyNanosGauge = Gauge.builder((String)"basekv.load.est.avglatency", () -> this.latestHint.getLoadOrDefault(LOAD_TYPE_AVG_LATENCY_NANOS, 0.0)).tags(tags).tags(new String[]{"type", this.type()}).register((MeterRegistry)Metrics.globalRegistry);
    }

    public void reset(Boundary boundary) {
        this.trackedKeySlots.clear();
        this.recentLoadHints.clear();
    }

    public SplitHint estimate() {
        long currentSlot = this.getSlot();
        this.trackedKeySlots.headMap(currentSlot - 2L).clear();
        this.recentLoadHints.headMap(currentSlot).clear();
        this.latestHint = this.recentLoadHints.computeIfAbsent(currentSlot, n -> this.doEstimate(n - 1L));
        return this.latestHint;
    }

    protected void onRecord(IKVLoadRecord kvLoadRecord) {
        long startNanos = kvLoadRecord.startNanos();
        int kvIOs = kvLoadRecord.getKVIOs();
        long kvNanos = kvLoadRecord.getKVIONanos();
        Map loadDistribution = kvLoadRecord.keyDistribution();
        long now = this.nanoSource.get();
        long currentSlot = now / this.windowSizeNanos;
        long mySlot = startNanos / this.windowSizeNanos;
        this.trackedKeySlots.headMap(currentSlot - 1L).clear();
        if (mySlot < currentSlot) {
            long slotBegin = currentSlot * this.windowSizeNanos;
            this.trackedKeySlots.computeIfAbsent(currentSlot, k -> new LoadRecordWindow()).record(loadDistribution, kvIOs, kvNanos, now - slotBegin);
            if (mySlot + 1L < currentSlot) {
                this.trackedKeySlots.computeIfAbsent(currentSlot - 1L, k -> new LoadRecordWindow()).record(loadDistribution, kvIOs, kvNanos, this.windowSizeNanos);
            } else {
                this.trackedKeySlots.computeIfAbsent(currentSlot - 1L, k -> new LoadRecordWindow()).record(loadDistribution, kvIOs, kvNanos, slotBegin - startNanos);
            }
            this.recentLoadHints.put(currentSlot - 1L, this.doEstimate(currentSlot - 1L));
        } else {
            this.trackedKeySlots.computeIfAbsent(currentSlot, k -> new LoadRecordWindow()).record(loadDistribution, kvIOs, kvNanos, now - startNanos);
        }
    }

    protected abstract String type();

    private SplitHint doEstimate(long slot) {
        LoadRecordWindow loadHint = (LoadRecordWindow)this.trackedKeySlots.get(slot);
        if (loadHint == null) {
            return SplitHint.newBuilder().setType(this.type()).putLoad(LOAD_TYPE_IO_DENSITY, 0.0).putLoad(LOAD_TYPE_IO_LATENCY_NANOS, 0.0).putLoad(LOAD_TYPE_AVG_LATENCY_NANOS, 0.0).build();
        }
        SplitHint.Builder hintBuilder = SplitHint.newBuilder().setType(this.type());
        hintBuilder.putLoad(LOAD_TYPE_IO_DENSITY, (double)loadHint.ioDensity());
        hintBuilder.putLoad(LOAD_TYPE_IO_LATENCY_NANOS, (double)loadHint.ioLatencyNanos());
        hintBuilder.putLoad(LOAD_TYPE_AVG_LATENCY_NANOS, (double)loadHint.avgLatencyNanos());
        loadHint.estimateSplitKey().ifPresent(arg_0 -> ((SplitHint.Builder)hintBuilder).setSplitKey(arg_0));
        return hintBuilder.build();
    }

    private long getSlot() {
        long nano = this.nanoSource.get();
        return nano / this.windowSizeNanos;
    }

    public void close() {
        Metrics.globalRegistry.remove(this.ioDensityGuage.getId());
        Metrics.globalRegistry.remove(this.ioLatencyNanosGauge.getId());
        Metrics.globalRegistry.remove(this.avgLatencyNanosGauge.getId());
    }
}

