/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.common.comm;

import com.aliyun.oss.common.utils.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.http.conn.HttpClientConnectionManager;

public final class IdleConnectionReaper
extends Thread {
    private static final int REAP_INTERVAL_MILLISECONDS = 5000;
    private static final ArrayList<HttpClientConnectionManager> connectionManagers = new ArrayList();
    private static IdleConnectionReaper instance;
    private static long idleConnectionTime;
    private volatile boolean shuttingDown;

    private IdleConnectionReaper() {
        super("idle_connection_reaper");
        this.setDaemon(true);
    }

    public static synchronized boolean registerConnectionManager(HttpClientConnectionManager connectionManager) {
        if (instance == null) {
            instance = new IdleConnectionReaper();
            instance.start();
        }
        return connectionManagers.add(connectionManager);
    }

    public static synchronized boolean removeConnectionManager(HttpClientConnectionManager connectionManager) {
        boolean b = connectionManagers.remove(connectionManager);
        if (connectionManagers.isEmpty()) {
            IdleConnectionReaper.shutdown();
        }
        return b;
    }

    private void markShuttingDown() {
        this.shuttingDown = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        block8: while (true) {
            if (this.shuttingDown) {
                LogUtils.getLog().debug("Shutting down reaper thread.");
                return;
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                List connectionManagers = null;
                Object object = IdleConnectionReaper.class;
                // MONITORENTER : com.aliyun.oss.common.comm.IdleConnectionReaper.class
                connectionManagers = (List)IdleConnectionReaper.connectionManagers.clone();
                // MONITOREXIT : object
                object = connectionManagers.iterator();
                while (true) {
                    if (!object.hasNext()) continue block8;
                    HttpClientConnectionManager connectionManager = (HttpClientConnectionManager)object.next();
                    try {
                        connectionManager.closeExpiredConnections();
                        connectionManager.closeIdleConnections(idleConnectionTime, TimeUnit.MILLISECONDS);
                    }
                    catch (Exception ex) {
                        LogUtils.getLog().warn("Unable to close idle connections", ex);
                    }
                }
            }
            catch (Throwable t) {
                LogUtils.getLog().debug("Reaper thread: ", t);
                continue;
            }
            break;
        }
    }

    public static synchronized boolean shutdown() {
        if (instance != null) {
            instance.markShuttingDown();
            instance.interrupt();
            connectionManagers.clear();
            instance = null;
            return true;
        }
        return false;
    }

    public static synchronized int size() {
        return connectionManagers.size();
    }

    public static synchronized void setIdleConnectionTime(long idletime) {
        idleConnectionTime = idletime;
    }

    static {
        idleConnectionTime = 60000L;
    }
}

