/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.kerberos.components;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.directory.api.asn1.AbstractAsn1Object;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.util.Strings;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.kerberos.codec.types.TransitedEncodingType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransitedEncoding
extends AbstractAsn1Object {
    private static final Logger log = LoggerFactory.getLogger(TransitedEncoding.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();
    private TransitedEncodingType trType = TransitedEncodingType.NULL;
    private byte[] contents = Strings.EMPTY_BYTES;
    private int trTypeLength;
    private int contentsLength;
    private int transitedEncodingLength;

    public byte[] getContents() {
        return this.contents;
    }

    public void setContents(byte[] contents) {
        this.contents = contents;
    }

    public TransitedEncodingType getTrType() {
        return this.trType;
    }

    public void setTrType(TransitedEncodingType trType) {
        this.trType = trType;
    }

    @Override
    public int computeLength() {
        this.trTypeLength = 2 + BerValue.getNbBytes((int)this.trType.getValue());
        this.transitedEncodingLength = 1 + TLV.getNbBytes((int)this.trTypeLength) + this.trTypeLength;
        this.contentsLength = this.contents == null ? 2 : 1 + TLV.getNbBytes((int)this.contents.length) + this.contents.length;
        this.transitedEncodingLength += 1 + TLV.getNbBytes((int)this.contentsLength) + this.contentsLength;
        int transitedEncodingSeqLength = 1 + BerValue.getNbBytes((int)this.transitedEncodingLength) + this.transitedEncodingLength;
        return transitedEncodingSeqLength;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException(I18n.err(I18n.ERR_148, new Object[0]));
        }
        try {
            buffer.put(UniversalTag.SEQUENCE.getValue());
            buffer.put(TLV.getBytes((int)this.transitedEncodingLength));
            buffer.put((byte)-96);
            buffer.put(TLV.getBytes((int)this.trTypeLength));
            BerValue.encode((ByteBuffer)buffer, (int)this.trType.getValue());
            buffer.put((byte)-95);
            buffer.put(TLV.getBytes((int)this.contentsLength));
            BerValue.encode((ByteBuffer)buffer, (byte[])this.contents);
        }
        catch (BufferOverflowException boe) {
            log.error(I18n.err(I18n.ERR_147, 1 + TLV.getNbBytes((int)this.transitedEncodingLength) + this.transitedEncodingLength, buffer.capacity()));
            throw new EncoderException(I18n.err(I18n.ERR_138, new Object[0]));
        }
        if (IS_DEBUG) {
            log.debug("TransitedEncoding encoding : {}", (Object)Strings.dumpBytes(buffer.array()));
            log.debug("TransitedEncoding initial value : {}", (Object)this.toString());
        }
        return buffer;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.contents);
        result = 31 * result + (this.trType == null ? 0 : this.trType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        TransitedEncoding other = (TransitedEncoding)obj;
        if (!Arrays.equals(this.contents, other.contents)) {
            return false;
        }
        return this.trType == other.trType;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TransitedEncoding : {\n");
        sb.append("    tr-type: ").append((Object)this.trType).append('\n');
        sb.append("    contents: ").append(Strings.dumpBytes(this.contents)).append("\n}\n");
        return sb.toString();
    }
}

