/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.ssl;

import java.io.IOException;
import java.util.ArrayList;
import javax.net.ssl.SSLEngine;
import org.apache.hadoop.classification.InterfaceAudience;
import org.mortbay.jetty.security.SslSelectChannelConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class SslSelectChannelConnectorSecure
extends SslSelectChannelConnector {
    public static final Logger LOG = LoggerFactory.getLogger(SslSelectChannelConnectorSecure.class);

    @Override
    protected SSLEngine createSSLEngine() throws IOException {
        SSLEngine engine = super.createSSLEngine();
        ArrayList<String> nonSSLProtocols = new ArrayList<String>();
        for (String p : engine.getEnabledProtocols()) {
            if (p.contains("SSLv3")) continue;
            nonSSLProtocols.add(p);
        }
        engine.setEnabledProtocols(nonSSLProtocols.toArray(new String[nonSSLProtocols.size()]));
        return engine;
    }

    @Override
    public boolean isRunning() {
        if (super.isRunning()) {
            return true;
        }
        LOG.warn("HttpServer Acceptor: isRunning is false. Rechecking.");
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
        boolean runState = super.isRunning();
        LOG.warn("HttpServer Acceptor: isRunning is " + runState);
        return runState;
    }
}

