/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.AbstractDNSToSwitchMapping;
import org.apache.hadoop.net.CachedDNSToSwitchMapping;
import org.apache.hadoop.net.DNSToSwitchMapping;
import org.apache.hadoop.util.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class ScriptBasedMapping
extends CachedDNSToSwitchMapping {
    static final int MIN_ALLOWABLE_ARGS = 1;
    static final int DEFAULT_ARG_COUNT = 100;
    static final String SCRIPT_FILENAME_KEY = "net.topology.script.file.name";
    static final String SCRIPT_ARG_COUNT_KEY = "net.topology.script.number.args";
    public static final String NO_SCRIPT = "no script";

    public ScriptBasedMapping() {
        this(new RawScriptBasedMapping());
    }

    public ScriptBasedMapping(DNSToSwitchMapping rawMap) {
        super(rawMap);
    }

    public ScriptBasedMapping(Configuration conf) {
        this();
        this.setConf(conf);
    }

    private RawScriptBasedMapping getRawMapping() {
        return (RawScriptBasedMapping)this.rawMapping;
    }

    @Override
    public Configuration getConf() {
        return this.getRawMapping().getConf();
    }

    @Override
    public String toString() {
        return "script-based mapping with " + this.getRawMapping().toString();
    }

    @Override
    public void setConf(Configuration conf) {
        super.setConf(conf);
        this.getRawMapping().setConf(conf);
    }

    protected static class RawScriptBasedMapping
    extends AbstractDNSToSwitchMapping {
        private String scriptName;
        private int maxArgs;
        private static final Logger LOG = LoggerFactory.getLogger(ScriptBasedMapping.class);

        @Override
        public void setConf(Configuration conf) {
            super.setConf(conf);
            if (conf != null) {
                this.scriptName = conf.get(ScriptBasedMapping.SCRIPT_FILENAME_KEY);
                this.maxArgs = conf.getInt(ScriptBasedMapping.SCRIPT_ARG_COUNT_KEY, 100);
            } else {
                this.scriptName = null;
                this.maxArgs = 0;
            }
        }

        @Override
        public List<String> resolve(List<String> names) {
            ArrayList<String> m3 = new ArrayList<String>(names.size());
            if (names.isEmpty()) {
                return m3;
            }
            if (this.scriptName == null) {
                for (String name : names) {
                    m3.add("/default-rack");
                }
                return m3;
            }
            String output = this.runResolveCommand(names, this.scriptName);
            if (output != null) {
                StringTokenizer allSwitchInfo = new StringTokenizer(output);
                while (allSwitchInfo.hasMoreTokens()) {
                    String switchInfo = allSwitchInfo.nextToken();
                    m3.add(switchInfo);
                }
                if (m3.size() != names.size()) {
                    LOG.error("Script " + this.scriptName + " returned " + Integer.toString(m3.size()) + " values when " + Integer.toString(names.size()) + " were expected.");
                    return null;
                }
            } else {
                return null;
            }
            return m3;
        }

        protected String runResolveCommand(List<String> args2, String commandScriptName) {
            int loopCount = 0;
            if (args2.size() == 0) {
                return null;
            }
            StringBuilder allOutput = new StringBuilder();
            int numProcessed = 0;
            if (this.maxArgs < 1) {
                LOG.warn("Invalid value " + Integer.toString(this.maxArgs) + " for " + ScriptBasedMapping.SCRIPT_ARG_COUNT_KEY + "; must be >= " + Integer.toString(1));
                return null;
            }
            while (numProcessed != args2.size()) {
                int start = this.maxArgs * loopCount;
                ArrayList<String> cmdList = new ArrayList<String>();
                cmdList.add(commandScriptName);
                for (numProcessed = start; numProcessed < start + this.maxArgs && numProcessed < args2.size(); ++numProcessed) {
                    cmdList.add(args2.get(numProcessed));
                }
                File dir = null;
                String userDir = System.getProperty("user.dir");
                if (userDir != null) {
                    dir = new File(userDir);
                }
                Shell.ShellCommandExecutor s2 = new Shell.ShellCommandExecutor(cmdList.toArray(new String[cmdList.size()]), dir);
                try {
                    s2.execute();
                    allOutput.append(s2.getOutput()).append(" ");
                }
                catch (Exception e) {
                    LOG.warn("Exception running " + s2, (Throwable)e);
                    return null;
                }
                ++loopCount;
            }
            return allOutput.toString();
        }

        @Override
        public boolean isSingleSwitch() {
            return this.scriptName == null;
        }

        public String toString() {
            return this.scriptName != null ? "script " + this.scriptName : ScriptBasedMapping.NO_SCRIPT;
        }

        @Override
        public void reloadCachedMappings() {
        }

        @Override
        public void reloadCachedMappings(List<String> names) {
        }
    }
}

