/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.jwk;

import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.util.JSONObjectUtils;
import com.nimbusds.jose.util.URLUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.apache.commons.io.FileUtils;

public class JWKSet {
    public static final String MIME_TYPE = "application/jwk-set+json; charset=UTF-8";
    private final List<JWK> keys = new LinkedList<JWK>();
    private final Map<String, Object> customMembers = new HashMap<String, Object>();

    public JWKSet() {
    }

    public JWKSet(JWK key) {
        if (key == null) {
            throw new IllegalArgumentException("The JWK must not be null");
        }
        this.keys.add(key);
    }

    public JWKSet(List<JWK> keys) {
        if (keys == null) {
            throw new IllegalArgumentException("The JWK list must not be null");
        }
        this.keys.addAll(keys);
    }

    public JWKSet(List<JWK> keys, Map<String, Object> customMembers) {
        if (keys == null) {
            throw new IllegalArgumentException("The JWK list must not be null");
        }
        this.keys.addAll(keys);
        this.customMembers.putAll(customMembers);
    }

    public List<JWK> getKeys() {
        return this.keys;
    }

    public JWK getKeyByKeyId(String kid) {
        for (JWK key : this.getKeys()) {
            if (key.getKeyID() == null || !key.getKeyID().equals(kid)) continue;
            return key;
        }
        return null;
    }

    public Map<String, Object> getAdditionalMembers() {
        return this.customMembers;
    }

    public JWKSet toPublicJWKSet() {
        LinkedList<JWK> publicKeyList = new LinkedList<JWK>();
        for (JWK key : this.keys) {
            JWK publicKey = key.toPublicJWK();
            if (publicKey == null) continue;
            publicKeyList.add(publicKey);
        }
        return new JWKSet(publicKeyList, this.customMembers);
    }

    public JSONObject toJSONObject() {
        return this.toJSONObject(true);
    }

    public JSONObject toJSONObject(boolean publicKeysOnly) {
        JSONObject o = new JSONObject(this.customMembers);
        JSONArray a = new JSONArray();
        for (JWK key : this.keys) {
            if (publicKeysOnly) {
                JWK publicKey = key.toPublicJWK();
                if (publicKey == null) continue;
                a.add(publicKey.toJSONObject());
                continue;
            }
            a.add(key.toJSONObject());
        }
        o.put("keys", a);
        return o;
    }

    public String toString() {
        return this.toJSONObject().toString();
    }

    public static JWKSet parse(String s) throws ParseException {
        return JWKSet.parse(JSONObjectUtils.parseJSONObject(s));
    }

    public static JWKSet parse(JSONObject json) throws ParseException {
        JSONArray keyArray = JSONObjectUtils.getJSONArray(json, "keys");
        LinkedList<JWK> keys = new LinkedList<JWK>();
        for (int i = 0; i < keyArray.size(); ++i) {
            if (!(keyArray.get(i) instanceof JSONObject)) {
                throw new ParseException("The \"keys\" JSON array must contain JSON objects only", 0);
            }
            JSONObject keyJSON = (JSONObject)keyArray.get(i);
            try {
                keys.add(JWK.parse(keyJSON));
                continue;
            }
            catch (ParseException e) {
                throw new ParseException("Invalid JWK at position " + i + ": " + e.getMessage(), 0);
            }
        }
        JWKSet jwkSet = new JWKSet(keys);
        for (Map.Entry entry : json.entrySet()) {
            if (entry.getKey() == null || ((String)entry.getKey()).equals("keys")) continue;
            jwkSet.getAdditionalMembers().put((String)entry.getKey(), entry.getValue());
        }
        return jwkSet;
    }

    public static JWKSet load(File file) throws IOException, ParseException {
        return JWKSet.parse(FileUtils.readFileToString(file));
    }

    public static JWKSet load(URL url, int connectTimeout, int readTimeout, int sizeLimit) throws IOException, ParseException {
        return JWKSet.parse(URLUtils.read(url, connectTimeout, readTimeout, sizeLimit));
    }

    public static JWKSet load(URL url) throws IOException, ParseException {
        return JWKSet.parse(URLUtils.read(url, 0, 0, -1));
    }
}

