/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.impl.rest;

import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class SimpleHandler
extends DefaultHandler {
    private static final Log log = LogFactory.getLog(SimpleHandler.class);
    private XMLReader xr = null;
    private StringBuffer textContent = null;
    protected SimpleHandler currentHandler = null;
    protected SimpleHandler parentHandler = null;

    public SimpleHandler(XMLReader xr) {
        this.xr = xr;
        this.textContent = new StringBuffer();
        this.currentHandler = this;
    }

    public void transferControlToHandler(SimpleHandler toHandler) {
        this.currentHandler = toHandler;
        toHandler.parentHandler = this;
        this.xr.setContentHandler(this.currentHandler);
        this.xr.setErrorHandler(this.currentHandler);
    }

    public void returnControlToParentHandler() {
        if (this.isChildHandler()) {
            this.parentHandler.currentHandler = this.parentHandler;
            this.parentHandler.controlReturned(this);
            this.currentHandler = this.parentHandler;
            this.xr.setContentHandler(this.currentHandler);
            this.xr.setErrorHandler(this.currentHandler);
        } else {
            log.debug("Ignoring call to return control to parent handler, as this class has no parent: " + this.getClass().getName());
        }
    }

    public boolean isChildHandler() {
        return this.parentHandler != null;
    }

    public void controlReturned(SimpleHandler childHandler) {
    }

    public void startElement(String uri, String name, String qName, Attributes attrs) {
        try {
            Method method = this.currentHandler.getClass().getMethod("start" + name, new Class[0]);
            method.invoke((Object)this.currentHandler, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            log.debug("Skipped non-existent SimpleHandler subclass's startElement method for '" + name + "' in " + this.getClass().getName());
        }
        catch (Throwable t) {
            log.error("Unable to invoke SimpleHandler subclass's startElement method for '" + name + "' in " + this.getClass().getName(), t);
        }
    }

    public void endElement(String uri, String name, String qName) {
        String elementText = this.textContent.toString().trim();
        try {
            Method method = this.currentHandler.getClass().getMethod("end" + name, String.class);
            method.invoke((Object)this.currentHandler, elementText);
        }
        catch (NoSuchMethodException e) {
            log.debug("Skipped non-existent SimpleHandler subclass's endElement method for '" + name + "' in " + this.getClass().getName());
        }
        catch (Throwable t) {
            log.error("Unable to invoke SimpleHandler subclass's endElement method for '" + name + "' in " + this.getClass().getName(), t);
        }
        this.textContent = new StringBuffer();
    }

    public void characters(char[] ch, int start, int length) {
        this.textContent.append(ch, start, length);
    }
}

