/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.dynamodbv2.model.KinesisDataStreamDestination;

@SdkInternalApi
public class KinesisDataStreamDestinationMarshaller {
    private static final MarshallingInfo<String> STREAMARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StreamArn").build();
    private static final MarshallingInfo<String> DESTINATIONSTATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DestinationStatus").build();
    private static final MarshallingInfo<String> DESTINATIONSTATUSDESCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DestinationStatusDescription").build();
    private static final KinesisDataStreamDestinationMarshaller instance = new KinesisDataStreamDestinationMarshaller();

    public static KinesisDataStreamDestinationMarshaller getInstance() {
        return instance;
    }

    public void marshall(KinesisDataStreamDestination kinesisDataStreamDestination, ProtocolMarshaller protocolMarshaller) {
        if (kinesisDataStreamDestination == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(kinesisDataStreamDestination.getStreamArn(), STREAMARN_BINDING);
            protocolMarshaller.marshall(kinesisDataStreamDestination.getDestinationStatus(), DESTINATIONSTATUS_BINDING);
            protocolMarshaller.marshall(kinesisDataStreamDestination.getDestinationStatusDescription(), DESTINATIONSTATUSDESCRIPTION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

