/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import java.util.Locale;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public enum S3AInputPolicy {
    Normal("normal"),
    Sequential("sequential"),
    Random("random");

    private static final Logger LOG;
    private final String policy;

    private S3AInputPolicy(String policy) {
        this.policy = policy;
    }

    public String toString() {
        return this.policy;
    }

    public static S3AInputPolicy getPolicy(String name) {
        String trimmed;
        switch (trimmed = name.trim().toLowerCase(Locale.ENGLISH)) {
            case "normal": {
                return Normal;
            }
            case "random": {
                return Random;
            }
            case "sequential": {
                return Sequential;
            }
        }
        LOG.warn("Unrecognized fs.s3a.experimental.input.fadvise value: \"{}\"", (Object)trimmed);
        return Normal;
    }

    static {
        LOG = LoggerFactory.getLogger(S3AInputPolicy.class);
    }
}

