/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluss.lake.paimon.tiering;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.fluss.lake.committer.BucketOffset;
import org.apache.fluss.lake.committer.CommittedLakeSnapshot;
import org.apache.fluss.lake.committer.LakeCommitter;
import org.apache.fluss.lake.paimon.tiering.PaimonCatalogProvider;
import org.apache.fluss.lake.paimon.tiering.PaimonCommittable;
import org.apache.fluss.lake.paimon.tiering.PaimonWriteResult;
import org.apache.fluss.lake.paimon.utils.PaimonConversions;
import org.apache.fluss.metadata.TablePath;
import org.apache.fluss.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.fluss.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.fluss.utils.Preconditions;
import org.apache.fluss.utils.json.BucketOffsetJsonSerde;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.Snapshot;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.manifest.IndexManifestEntry;
import org.apache.paimon.manifest.ManifestCommittable;
import org.apache.paimon.manifest.ManifestEntry;
import org.apache.paimon.operation.FileStoreCommit;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.sink.CommitCallback;
import org.apache.paimon.utils.SnapshotManager;

public class PaimonLakeCommitter
implements LakeCommitter<PaimonWriteResult, PaimonCommittable> {
    private final Catalog paimonCatalog;
    private final FileStoreTable fileStoreTable;
    private FileStoreCommit fileStoreCommit;
    private static final ThreadLocal<Long> currentCommitSnapshotId = new ThreadLocal();
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public PaimonLakeCommitter(PaimonCatalogProvider paimonCatalogProvider, TablePath tablePath) throws IOException {
        this.paimonCatalog = paimonCatalogProvider.get();
        this.fileStoreTable = this.getTable(tablePath);
    }

    public PaimonCommittable toCommittable(List<PaimonWriteResult> paimonWriteResults) throws IOException {
        ManifestCommittable committable = new ManifestCommittable(Long.MAX_VALUE);
        for (PaimonWriteResult paimonWriteResult : paimonWriteResults) {
            committable.addFileCommittable(paimonWriteResult.commitMessage());
        }
        return new PaimonCommittable(committable);
    }

    public long commit(PaimonCommittable committable, Map<String, String> snapshotProperties) throws IOException {
        ManifestCommittable manifestCommittable = committable.manifestCommittable();
        snapshotProperties.forEach(manifestCommittable::addProperty);
        try {
            this.fileStoreCommit = this.fileStoreTable.store().newCommit("__fluss_lake_tiering", this.fileStoreTable);
            this.fileStoreCommit.commit(manifestCommittable, false);
            Long commitSnapshotId = currentCommitSnapshotId.get();
            currentCommitSnapshotId.remove();
            return (Long)Preconditions.checkNotNull((Object)commitSnapshotId, (String)"Paimon committed snapshot id must be non-null.");
        }
        catch (Throwable t) {
            if (this.fileStoreCommit != null) {
                this.fileStoreCommit.abort(manifestCommittable.fileCommittables());
            }
            throw new IOException(t);
        }
    }

    public void abort(PaimonCommittable committable) throws IOException {
        this.fileStoreCommit = this.fileStoreTable.store().newCommit("__fluss_lake_tiering", this.fileStoreTable);
        this.fileStoreCommit.abort(committable.manifestCommittable().fileCommittables());
    }

    @Nullable
    public CommittedLakeSnapshot getMissingLakeSnapshot(@Nullable Long latestLakeSnapshotIdOfFluss) throws IOException {
        Snapshot latestLakeSnapshotOfLake = this.getCommittedLatestSnapshotOfLake("__fluss_lake_tiering");
        if (latestLakeSnapshotOfLake == null) {
            return null;
        }
        if (latestLakeSnapshotIdOfFluss != null && latestLakeSnapshotOfLake.id() <= latestLakeSnapshotIdOfFluss) {
            return null;
        }
        CommittedLakeSnapshot committedLakeSnapshot = new CommittedLakeSnapshot(latestLakeSnapshotOfLake.id());
        if (latestLakeSnapshotOfLake.properties() == null) {
            throw new IOException("Failed to load committed lake snapshot properties from Paimon.");
        }
        Map<String, String> lakeSnapshotProperties = latestLakeSnapshotOfLake.properties();
        if (lakeSnapshotProperties == null) {
            throw new IllegalArgumentException("Cannot resume tiering from an old version(v0.7) of tiering service. The snapshot was committed to the lake storage but failed to commit to Fluss. To resolve this:\n1. Run the old tiering service(v0.7) again to complete the Fluss commit\n2. Then you can resume tiering with the newer version of tiering service");
        }
        String flussOffsetProperties = lakeSnapshotProperties.get("fluss-offsets");
        for (JsonNode node : OBJECT_MAPPER.readTree(flussOffsetProperties)) {
            BucketOffset bucketOffset = BucketOffsetJsonSerde.INSTANCE.deserialize(node);
            if (bucketOffset.getPartitionId() != null) {
                committedLakeSnapshot.addPartitionBucket(bucketOffset.getPartitionId(), bucketOffset.getPartitionQualifiedName(), bucketOffset.getBucket(), bucketOffset.getLogOffset());
                continue;
            }
            committedLakeSnapshot.addBucket(bucketOffset.getBucket(), bucketOffset.getLogOffset());
        }
        return committedLakeSnapshot;
    }

    @Nullable
    private Snapshot getCommittedLatestSnapshotOfLake(String commitUser) throws IOException {
        SnapshotManager snapshotManager = this.fileStoreTable.snapshotManager();
        Long userCommittedSnapshotIdOrLatestCommitId = this.fileStoreTable.snapshotManager().pickOrLatest(snapshot -> snapshot.commitUser().equals(commitUser));
        if (userCommittedSnapshotIdOrLatestCommitId == null) {
            return null;
        }
        Snapshot snapshot2 = snapshotManager.tryGetSnapshot(userCommittedSnapshotIdOrLatestCommitId);
        if (!snapshot2.commitUser().equals(commitUser)) {
            return null;
        }
        return snapshot2;
    }

    public void close() throws Exception {
        try {
            if (this.fileStoreCommit != null) {
                this.fileStoreCommit.close();
            }
            if (this.paimonCatalog != null) {
                this.paimonCatalog.close();
            }
        }
        catch (Exception e) {
            throw new IOException("Failed to close PaimonLakeCommitter.", e);
        }
    }

    private FileStoreTable getTable(TablePath tablePath) throws IOException {
        try {
            FileStoreTable table = (FileStoreTable)this.paimonCatalog.getTable(PaimonConversions.toPaimon(tablePath)).copy(Collections.singletonMap(CoreOptions.COMMIT_CALLBACKS.key(), PaimonCommitCallback.class.getName()));
            return table;
        }
        catch (Exception e) {
            throw new IOException("Failed to get table " + String.valueOf(tablePath) + " in Paimon.", e);
        }
    }

    public static class PaimonCommitCallback
    implements CommitCallback {
        @Override
        public void call(List<ManifestEntry> list, List<IndexManifestEntry> indexFiles, Snapshot snapshot) {
            currentCommitSnapshotId.set(snapshot.id());
        }

        @Override
        public void retry(ManifestCommittable manifestCommittable) {
        }

        @Override
        public void close() throws Exception {
        }
    }
}

