/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.casting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.paimon.casting.ArrayToStringCastRule;
import org.apache.paimon.casting.BinaryToBinaryCastRule;
import org.apache.paimon.casting.BinaryToStringCastRule;
import org.apache.paimon.casting.BooleanToNumericCastRule;
import org.apache.paimon.casting.BooleanToStringCastRule;
import org.apache.paimon.casting.CastExecutor;
import org.apache.paimon.casting.CastRule;
import org.apache.paimon.casting.CastRulePredicate;
import org.apache.paimon.casting.DateToStringCastRule;
import org.apache.paimon.casting.DateToTimestampCastRule;
import org.apache.paimon.casting.DecimalToDecimalCastRule;
import org.apache.paimon.casting.DecimalToNumericPrimitiveCastRule;
import org.apache.paimon.casting.MapToStringCastRule;
import org.apache.paimon.casting.NumericPrimitiveCastRule;
import org.apache.paimon.casting.NumericPrimitiveToDecimalCastRule;
import org.apache.paimon.casting.NumericPrimitiveToTimestamp;
import org.apache.paimon.casting.NumericToBooleanCastRule;
import org.apache.paimon.casting.NumericToStringCastRule;
import org.apache.paimon.casting.RowToStringCastRule;
import org.apache.paimon.casting.StringToBinaryCastRule;
import org.apache.paimon.casting.StringToBooleanCastRule;
import org.apache.paimon.casting.StringToDateCastRule;
import org.apache.paimon.casting.StringToDecimalCastRule;
import org.apache.paimon.casting.StringToNumericPrimitiveCastRule;
import org.apache.paimon.casting.StringToStringCastRule;
import org.apache.paimon.casting.StringToTimeCastRule;
import org.apache.paimon.casting.StringToTimestampCastRule;
import org.apache.paimon.casting.TimeToStringCastRule;
import org.apache.paimon.casting.TimeToTimestampCastRule;
import org.apache.paimon.casting.TimestampToDateCastRule;
import org.apache.paimon.casting.TimestampToNumericPrimitiveCastRule;
import org.apache.paimon.casting.TimestampToStringCastRule;
import org.apache.paimon.casting.TimestampToTimeCastRule;
import org.apache.paimon.casting.TimestampToTimestampCastRule;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeFamily;
import org.apache.paimon.types.DataTypeRoot;
import org.apache.paimon.types.DataTypes;

public class CastExecutors {
    private static final CastExecutors INSTANCE = new CastExecutors();
    private static final CastExecutor<?, ?> IDENTITY_CAST_EXECUTOR;
    private final Map<Object, Map<Object, CastRule<?, ?>>> rules = new HashMap();

    @Nullable
    public static CastExecutor<?, ?> resolve(DataType inputType, DataType outputType) {
        CastRule<?, ?> rule = INSTANCE.internalResolve(inputType, outputType);
        if (rule == null) {
            return null;
        }
        return rule.create(inputType, outputType);
    }

    public static CastExecutor<?, ?> resolveToString(DataType inputType) {
        CastExecutor<?, ?> castExecutor = CastExecutors.resolve(inputType, DataTypes.STRING());
        if (castExecutor == null) {
            throw new UnsupportedOperationException("Cast " + inputType + " to StringType is not supported.");
        }
        return castExecutor;
    }

    public static CastExecutor<?, ?> identityCastExecutor() {
        return IDENTITY_CAST_EXECUTOR;
    }

    public static Optional<List<Object>> castLiteralsWithEvolution(List<Object> literals, DataType predicateType, DataType dataType) {
        if (predicateType.equalsIgnoreNullable(dataType)) {
            return Optional.of(literals);
        }
        CastRule<?, ?> castRule = INSTANCE.internalResolve(predicateType, dataType);
        if (castRule == null) {
            return Optional.empty();
        }
        if (castRule instanceof NumericPrimitiveCastRule && predicateType.is(DataTypeFamily.INTEGER_NUMERIC) && dataType.is(DataTypeFamily.INTEGER_NUMERIC) && CastExecutors.integerScaleLargerThan(predicateType.getTypeRoot(), dataType.getTypeRoot())) {
            CastExecutor<?, ?> castExecutor = castRule.create(predicateType, dataType);
            ArrayList<Number> newLiterals = new ArrayList<Number>(literals.size());
            for (Object literal : literals) {
                Number literalNumber = (Number)literal;
                Number newLiteralNumber = (Number)castExecutor.cast(literalNumber);
                if (newLiteralNumber.longValue() != literalNumber.longValue()) {
                    return Optional.empty();
                }
                newLiterals.add(newLiteralNumber);
            }
            return Optional.of(newLiterals);
        }
        return Optional.empty();
    }

    private static boolean integerScaleLargerThan(DataTypeRoot a, DataTypeRoot b) {
        return a == DataTypeRoot.SMALLINT && b == DataTypeRoot.TINYINT || a == DataTypeRoot.INTEGER && b != DataTypeRoot.BIGINT || a == DataTypeRoot.BIGINT;
    }

    private CastExecutors addRule(CastRule<?, ?> rule) {
        Map map;
        CastRulePredicate predicate = rule.getPredicateDefinition();
        for (DataType targetType : predicate.getTargetTypes()) {
            map = this.rules.computeIfAbsent(targetType, k -> new HashMap());
            for (DataTypeRoot inputTypeRoot : predicate.getInputTypeRoots()) {
                map.put(inputTypeRoot, rule);
            }
            for (DataTypeFamily inputTypeFamily : predicate.getInputTypeFamilies()) {
                map.put(inputTypeFamily, rule);
            }
        }
        for (DataTypeRoot targetTypeRoot : predicate.getTargetTypeRoots()) {
            map = this.rules.computeIfAbsent((Object)targetTypeRoot, k -> new HashMap());
            for (DataTypeRoot inputTypeRoot : predicate.getInputTypeRoots()) {
                map.put(inputTypeRoot, rule);
            }
            for (DataTypeFamily inputTypeFamily : predicate.getInputTypeFamilies()) {
                map.put(inputTypeFamily, rule);
            }
        }
        for (DataTypeFamily targetTypeFamily : predicate.getTargetTypeFamilies()) {
            map = this.rules.computeIfAbsent((Object)targetTypeFamily, k -> new HashMap());
            for (DataTypeRoot inputTypeRoot : predicate.getInputTypeRoots()) {
                map.put(inputTypeRoot, rule);
            }
            for (DataTypeFamily inputTypeFamily : predicate.getInputTypeFamilies()) {
                map.put(inputTypeFamily, rule);
            }
        }
        return this;
    }

    private CastRule<?, ?> internalResolve(DataType inputType, DataType targetType) {
        Iterator targetTypeRootFamilyIterator = Stream.concat(Stream.of(targetType), Stream.concat(Stream.of(targetType.getTypeRoot()), targetType.getTypeRoot().getFamilies().stream())).iterator();
        while (targetTypeRootFamilyIterator.hasNext()) {
            Optional<CastRule> rule;
            Object targetMapKey = targetTypeRootFamilyIterator.next();
            Map<Object, CastRule<?, ?>> inputTypeToCastRuleMap = this.rules.get(targetMapKey);
            if (inputTypeToCastRuleMap == null || !(rule = Stream.concat(Stream.of(inputType.getTypeRoot()), inputType.getTypeRoot().getFamilies().stream()).map(inputTypeToCastRuleMap::get).filter(Objects::nonNull).findFirst()).isPresent()) continue;
            return rule.get();
        }
        return null;
    }

    static {
        INSTANCE.addRule(DecimalToDecimalCastRule.INSTANCE).addRule(NumericPrimitiveToDecimalCastRule.INSTANCE).addRule(DecimalToNumericPrimitiveCastRule.INSTANCE).addRule(NumericPrimitiveCastRule.INSTANCE).addRule(NumericPrimitiveToTimestamp.INSTANCE).addRule(BooleanToNumericCastRule.INSTANCE).addRule(NumericToBooleanCastRule.INSTANCE).addRule(NumericToStringCastRule.INSTANCE).addRule(BooleanToStringCastRule.INSTANCE).addRule(TimestampToStringCastRule.INSTANCE).addRule(TimeToStringCastRule.INSTANCE).addRule(DateToStringCastRule.INSTANCE).addRule(StringToStringCastRule.INSTANCE).addRule(ArrayToStringCastRule.INSTANCE).addRule(MapToStringCastRule.INSTANCE).addRule(RowToStringCastRule.INSTANCE).addRule(StringToBooleanCastRule.INSTANCE).addRule(StringToDecimalCastRule.INSTANCE).addRule(StringToNumericPrimitiveCastRule.INSTANCE).addRule(StringToDateCastRule.INSTANCE).addRule(StringToTimeCastRule.INSTANCE).addRule(StringToTimestampCastRule.INSTANCE).addRule(StringToBinaryCastRule.INSTANCE).addRule(TimestampToTimestampCastRule.INSTANCE).addRule(TimestampToDateCastRule.INSTANCE).addRule(TimestampToTimeCastRule.INSTANCE).addRule(DateToTimestampCastRule.INSTANCE).addRule(TimeToTimestampCastRule.INSTANCE).addRule(TimestampToNumericPrimitiveCastRule.INSTANCE).addRule(BinaryToBinaryCastRule.INSTANCE).addRule(BinaryToStringCastRule.INSTANCE);
        IDENTITY_CAST_EXECUTOR = value -> value;
    }
}

