/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.catalog;

import java.util.List;
import java.util.concurrent.Callable;
import org.apache.paimon.Snapshot;
import org.apache.paimon.catalog.SnapshotCommit;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.operation.Lock;
import org.apache.paimon.partition.PartitionStatistics;
import org.apache.paimon.utils.SnapshotManager;

public class RenamingSnapshotCommit
implements SnapshotCommit {
    private final SnapshotManager snapshotManager;
    private final FileIO fileIO;
    private final Lock lock;

    public RenamingSnapshotCommit(SnapshotManager snapshotManager, Lock lock) {
        this.snapshotManager = snapshotManager;
        this.fileIO = snapshotManager.fileIO();
        this.lock = lock;
    }

    @Override
    public boolean commit(Snapshot snapshot, String branch, List<PartitionStatistics> statistics) throws Exception {
        Path newSnapshotPath = this.snapshotManager.branch().equals(branch) ? this.snapshotManager.snapshotPath(snapshot.id()) : this.snapshotManager.copyWithBranch(branch).snapshotPath(snapshot.id());
        Callable<Boolean> callable = () -> {
            boolean committed = this.fileIO.tryToWriteAtomic(newSnapshotPath, snapshot.toJson());
            if (committed) {
                this.snapshotManager.commitLatestHint(snapshot.id());
            }
            return committed;
        };
        return this.lock.runWithLock(() -> !this.fileIO.exists(newSnapshotPath) && (Boolean)callable.call() != false);
    }

    @Override
    public void close() throws Exception {
        this.lock.close();
    }
}

