/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.compression;

import com.github.luben.zstd.RecyclingBufferPool;
import com.github.luben.zstd.ZstdInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.apache.paimon.compression.BlockDecompressor;
import org.apache.paimon.compression.BufferDecompressionException;

public class ZstdBlockDecompressor
implements BlockDecompressor {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int decompress(byte[] src, int srcOff, int srcLen, byte[] dst, int dstOff) throws BufferDecompressionException {
        ByteArrayInputStream inputStream2 = new ByteArrayInputStream(src, srcOff, srcLen);
        try (ZstdInputStream decompressorStream = new ZstdInputStream(inputStream2, RecyclingBufferPool.INSTANCE);){
            int decompressedLen = 0;
            while (true) {
                int offset;
                int count;
                if ((count = decompressorStream.read(dst, offset = dstOff + decompressedLen, dst.length - offset)) <= 0) {
                    if (decompressorStream.available() == 0) break;
                    throw new BufferDecompressionException("Dst is too small and the decompression was not completed.");
                }
                decompressedLen += count;
            }
            int n = decompressedLen;
            return n;
        }
        catch (IOException e) {
            throw new BufferDecompressionException(e);
        }
    }
}

