/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.orc.filter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Arrays;
import org.apache.paimon.shade.org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.paimon.shade.org.apache.hadoop.hive.ql.io.sarg.PredicateLeaf;
import org.apache.paimon.shade.org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.paimon.shade.org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;

public class OrcFilters {

    public static class And
    extends Predicate {
        private final Predicate[] preds;

        public And(Predicate ... predicates) {
            this.preds = predicates;
        }

        @Override
        public SearchArgument.Builder add(SearchArgument.Builder builder) {
            SearchArgument.Builder withAnd = builder.startAnd();
            for (Predicate pred : this.preds) {
                withAnd = pred.add(withAnd);
            }
            return withAnd.end();
        }

        public String toString() {
            return "AND(" + Arrays.toString(this.preds) + ")";
        }
    }

    public static class Or
    extends Predicate {
        private final Predicate[] preds;

        public Or(Predicate ... predicates) {
            this.preds = predicates;
        }

        @Override
        public SearchArgument.Builder add(SearchArgument.Builder builder) {
            SearchArgument.Builder withOr = builder.startOr();
            for (Predicate p : this.preds) {
                withOr = p.add(withOr);
            }
            return withOr.end();
        }

        public String toString() {
            return "OR(" + Arrays.toString(this.preds) + ")";
        }
    }

    public static class Not
    extends Predicate {
        private final Predicate pred;

        public Not(Predicate predicate) {
            this.pred = predicate;
        }

        @Override
        public SearchArgument.Builder add(SearchArgument.Builder builder) {
            return this.pred.add(builder.startNot()).end();
        }

        public String toString() {
            return "NOT(" + this.pred.toString() + ")";
        }
    }

    public static class IsNull
    extends ColumnPredicate {
        public IsNull(String columnName, PredicateLeaf.Type literalType) {
            super(columnName, literalType);
        }

        @Override
        public SearchArgument.Builder add(SearchArgument.Builder builder) {
            return builder.isNull(this.columnName, this.literalType);
        }

        public String toString() {
            return this.columnName + " IS NULL";
        }
    }

    public static class LessThanEquals
    extends BinaryPredicate {
        public LessThanEquals(String columnName, PredicateLeaf.Type literalType, Serializable literal) {
            super(columnName, literalType, literal);
        }

        @Override
        public SearchArgument.Builder add(SearchArgument.Builder builder) {
            return builder.lessThanEquals(this.columnName, this.literalType, this.castLiteral(this.literal));
        }

        public String toString() {
            return this.columnName + " <= " + this.literal;
        }
    }

    public static class LessThan
    extends BinaryPredicate {
        public LessThan(String columnName, PredicateLeaf.Type literalType, Serializable literal) {
            super(columnName, literalType, literal);
        }

        @Override
        public SearchArgument.Builder add(SearchArgument.Builder builder) {
            return builder.lessThan(this.columnName, this.literalType, this.castLiteral(this.literal));
        }

        public String toString() {
            return this.columnName + " < " + this.literal;
        }
    }

    public static class Equals
    extends BinaryPredicate {
        public Equals(String columnName, PredicateLeaf.Type literalType, Serializable literal) {
            super(columnName, literalType, literal);
        }

        @Override
        public SearchArgument.Builder add(SearchArgument.Builder builder) {
            return builder.equals(this.columnName, this.literalType, this.castLiteral(this.literal));
        }

        public String toString() {
            return this.columnName + " = " + this.literal;
        }
    }

    static abstract class BinaryPredicate
    extends ColumnPredicate {
        final Serializable literal;

        BinaryPredicate(String columnName, PredicateLeaf.Type literalType, Serializable literal) {
            super(columnName, literalType);
            this.literal = literal;
        }
    }

    static abstract class ColumnPredicate
    extends Predicate {
        final String columnName;
        final PredicateLeaf.Type literalType;

        ColumnPredicate(String columnName, PredicateLeaf.Type literalType) {
            this.columnName = columnName;
            this.literalType = literalType;
        }

        Object castLiteral(Serializable literal) {
            switch (this.literalType) {
                case LONG: {
                    if (literal instanceof Byte) {
                        return new Long(((Byte)literal).byteValue());
                    }
                    if (literal instanceof Short) {
                        return new Long(((Short)literal).shortValue());
                    }
                    if (literal instanceof Integer) {
                        return new Long(((Integer)literal).intValue());
                    }
                    if (literal instanceof Long) {
                        return literal;
                    }
                    throw new IllegalArgumentException("A predicate on a LONG column requires an integer literal, i.e., Byte, Short, Integer, or Long.");
                }
                case FLOAT: {
                    if (literal instanceof Float) {
                        return new Double(((Float)literal).floatValue());
                    }
                    if (literal instanceof Double) {
                        return literal;
                    }
                    if (literal instanceof BigDecimal) {
                        return ((BigDecimal)literal).doubleValue();
                    }
                    throw new IllegalArgumentException("A predicate on a FLOAT column requires a floating literal, i.e., Float or Double.");
                }
                case STRING: {
                    if (literal instanceof String) {
                        return literal;
                    }
                    throw new IllegalArgumentException("A predicate on a STRING column requires a floating literal, i.e., Float or Double.");
                }
                case BOOLEAN: {
                    if (literal instanceof Boolean) {
                        return literal;
                    }
                    throw new IllegalArgumentException("A predicate on a BOOLEAN column requires a Boolean literal.");
                }
                case DATE: {
                    if (literal instanceof Date) {
                        return literal;
                    }
                    throw new IllegalArgumentException("A predicate on a DATE column requires a java.sql.Date literal.");
                }
                case TIMESTAMP: {
                    if (literal instanceof Timestamp) {
                        return literal;
                    }
                    throw new IllegalArgumentException("A predicate on a TIMESTAMP column requires a java.sql.Timestamp literal.");
                }
                case DECIMAL: {
                    if (literal instanceof BigDecimal) {
                        return new HiveDecimalWritable(HiveDecimal.create((BigDecimal)literal));
                    }
                    throw new IllegalArgumentException("A predicate on a DECIMAL column requires a BigDecimal literal.");
                }
            }
            throw new IllegalArgumentException("Unknown literal type " + (Object)((Object)this.literalType));
        }
    }

    public static abstract class Predicate
    implements Serializable {
        public abstract SearchArgument.Builder add(SearchArgument.Builder var1);
    }
}

